% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_thickness.R
\name{scale_thickness}
\alias{scale_thickness}
\alias{scale_thickness_shared}
\alias{scale_thickness_identity}
\alias{thickness}
\title{Scale for slab thickness}
\usage{
scale_thickness_shared(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = function(l) c(min(0, l[[1]]), l[[2]]),
  renormalize = FALSE,
  guide = "none"
)

scale_thickness_identity(..., guide = "none")

thickness(x = double())
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{renormalize}{When mapping values to the \code{thickness} scale, should those
values be allowed to be renormalized by geoms (e.g. via the \code{normalize} parameter
to \code{\link[=geom_slabinterval]{geom_slabinterval()}})? The default is \code{FALSE}: if \code{scale_thickness_shared()}
is in use, the geom-specific \code{normalize} parameter is ignored (this is achieved
by flagging values as already normalized by wrapping them in \code{thickness()}).
Set this to \code{TRUE} to allow geoms to also apply their own normalization.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{...}{Arguments passed to the underlying scale or guide functions. E.g. \code{\link[=scale_thickness_identity]{scale_thickness_identity()}}
passes arguments to \code{\link[=continuous_scale]{continuous_scale()}}. See that function for more details.}

\item{x}{An object (typically a \code{numeric()}) to be converted to a \code{thickness()}
object.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} representing a scale for the \code{thickness}
aesthetic for \code{ggdist} geoms. Can be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
This \pkg{ggplot2} scale linearly scales all \code{thickness} values of geoms
that support the \code{thickness} aesthetic (such as \code{\link[=geom_slabinterval]{geom_slabinterval()}}). It
can be used to align the \code{thickness} scales across multiple geoms (by default,
\code{thickness} is normalized on a per-geom level instead of as a global scale).
}
\details{
By default, normalization/scaling of slab thicknesses is controlled by geometries,
not by a \pkg{ggplot2} scale function. This allows various functionality not
otherwise possible, such as (1) allowing different geometries to have different
thickness scales and (2) allowing the user to control at what level of aggregation
(panels, groups, the entire plot, etc) thickness scaling is done via the \code{normalize}
parameter to \code{\link[=geom_slabinterval]{geom_slabinterval()}}.

However, this default approach has one drawback: two different geoms will always
have their own scaling of \code{thickness}. \code{\link[=scale_thickness_shared]{scale_thickness_shared()}} offers an
alternative approach: when added to a chart, all geoms will use the same
\code{thickness} scale, and geom-level normalization (via their \code{normalize} parameters)
is ignored. This is achieved by "marking" thickness values as already
normalized by wrapping them in the \code{\link[=thickness]{thickness()}} data type (this can be
disabled by setting \code{renormalize = TRUE}).

\code{\link[=thickness]{thickness()}} is used by \code{\link[=scale_thickness_shared]{scale_thickness_shared()}} to create \code{numeric()}-like
objects marked as being in units of slab "thickness". Unlike regular \code{numeric()}s,
\code{thickness()} values mapped onto the \code{thickness} aesthetic are not rescaled by
\code{\link[=scale_thickness_shared]{scale_thickness_shared()}} or \code{\link[=geom_slabinterval]{geom_slabinterval()}}. In most cases \code{thickness()}
is not useful directly; though it can be used to mark values that should not be
rescaled---see the definitions of \code{\link[=stat_ccdfinterval]{stat_ccdfinterval()}} and \code{\link[=stat_gradientinterval]{stat_gradientinterval()}}
for some usages.

Note: while a slightly more typical name for \code{scale_thickness_shared()} might
be \code{scale_thickness_continuous()}, the latter name would cause this scale
to be applied to all \code{thickness} aesthetics by default according to the rules
\pkg{ggplot2} uses to find default scales. Thus, to retain the usual behavior
of \code{\link[=stat_slabinterval]{stat_slabinterval()}} (per-geom normalization of \code{thickness}), this scale
is called \code{scale_thickness_shared()}.
}
\examples{
library(distributional)
library(ggplot2)
library(dplyr)

prior_post = data.frame(
  prior = dist_normal(0, 1),
  posterior = dist_normal(0.1, 0.5)
)

# By default, separate geoms have their own thickness scales, which means
# distributions plotted using two separate geoms will not have their slab
# functions drawn on the same scale (thus here, the two distributions have
# different areas under their density curves):
prior_post \%>\%
  ggplot() +
  stat_halfeye(aes(xdist = posterior)) +
  stat_slab(aes(xdist = prior), fill = NA, color = "red")

# For this kind of prior/posterior chart, it makes more sense to have the
# densities on the same scale; thus, the areas under both would be the same.
# We can do that using scale_thickness_shared():
prior_post \%>\%
  ggplot() +
  stat_halfeye(aes(xdist = posterior)) +
  stat_slab(aes(xdist = prior), fill = NA, color = "#e41a1c") +
  scale_thickness_shared()

}
\seealso{
The \code{thickness} aesthetic of \code{\link[=geom_slabinterval]{geom_slabinterval()}}.

Other ggdist scales: 
\code{\link{scale_colour_ramp}},
\code{\link{scales}}
}
\author{
Matthew Kay
}
\concept{ggdist scales}
