% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_interval.R
\name{stat_interval}
\alias{stat_interval}
\title{Multiple uncertainty interval plots (ggplot stat)}
\usage{
stat_interval(
  mapping = NULL,
  data = NULL,
  geom = "interval",
  position = "identity",
  ...,
  orientation = NA,
  interval_function = NULL,
  interval_args = list(),
  point_interval = median_qi,
  .width = c(0.5, 0.8, 0.95),
  show_point = FALSE,
  show_slab = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  .prob,
  fun.data,
  fun.args
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{stat_slabinterval} and \code{\link[=geom_slabinterval]{geom_slabinterval()}}}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. They may also be arguments to the paired geom
(e.g., \code{\link[=geom_pointinterval]{geom_pointinterval()}})}

\item{orientation}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}

\item{interval_function}{Custom function for generating intervals (for most common use cases the \code{point_interval}
argument will be easier to use). This function takes a data frame of aesthetics and a \code{.width} parameter (a vector
of interval widths), and returns a data frame with
columns \code{.width} (from the \code{.width} vector), \code{.value} (point summary) and \code{.lower} and \code{.upper}
(endpoints of the intervals, given the \code{.width}). Output will be converted to the appropriate \code{x}- or
\code{y}-based aesthetics depending on the value of \code{orientation}. If \code{interval_function} is \code{NULL},
\code{point_interval} is used instead.}

\item{interval_args}{Additional arguments passed to \code{interval_function} or \code{point_interval}.}

\item{point_interval}{A function from the \code{\link[=point_interval]{point_interval()}} family (e.g., \code{median_qi},
\code{mean_qi}, etc). This function should take in a vector of value, and should obey the
\code{.width} and \code{.simple_names} parameters of \code{\link[=point_interval]{point_interval()}} functions, such that when given
a vector with \code{.simple_names = TRUE} should return a data frame with variables \code{.value}, \code{.lower},
\code{.upper}, and \code{.width}. Output will be converted to the appropriate \code{x}- or \code{y}-based aesthetics
depending on the value of \code{orientation}. See the \code{\link[=point_interval]{point_interval()}} family of functions for
more information.}

\item{.width}{The \code{.width} argument passed to \code{interval_function} or \code{point_interval}.}

\item{show_point}{Should the point portion of the geom be drawn? Default \code{TRUE}.}

\item{show_slab}{Should the slab portion of the geom be drawn? Default \code{TRUE}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{.prob}{Deprecated. Use \code{.width} instead.}

\item{fun.data}{Deprecated. Use \code{point_interval} or \code{interval_function} instead.}

\item{fun.args}{Deprecated. Use \code{interval_args} instead.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Stat} representing a multiple interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
A combination of \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} and
\code{\link[=geom_slabinterval]{geom_slabinterval()}} with sensible defaults.
While the corresponding \code{geom}s are intended for use on
data frames that have already been summarized using a \code{\link[=point_interval]{point_interval()}}
function, these \code{stat}s are intended for use directly on data frames of draws, and
will perform the summarization using a \code{\link[=point_interval]{point_interval()}} function.
}
\section{Computed Variables}{

The following variables are computed by this stat and made available for
use in aesthetic specifications (\code{aes()}) using the \code{stat()} or \code{after_stat()}
functions:
\itemize{
\item \code{x} or \code{y}: For slabs, the input values to the slab function.
For intervals, the point summary from the interval function. Whether it is \code{x} or \code{y} depends on \code{orientation}
\item \code{xmin} or \code{ymin}: For intervals, the lower end of the interval from the interval function.
\item \code{xmax} or \code{ymax}: For intervals, the upper end of the interval from the interval function.
\item \code{.width}: For intervals, the interval width as a numeric value in \verb{[0, 1]}.
\item \code{level}: For intervals, the interval width as an ordered factor.
\item \code{f}: For slabs, the output values from the slab function (such as the PDF, CDF, or CCDF),
determined by \code{slab_type}.
\item \code{pdf}: For slabs, the probability density function.
\item \code{cdf}: For slabs, the cumulative distribution function.
\item \code{n}: For slabs, the number of data points summarized into that slab.
}
}

\section{Aesthetics}{

The slab+interval \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their three sub-geometries: the \strong{slab}, the \strong{point}, and
the \strong{interval}.

These \code{stat}s support the following aesthetics:
\itemize{
\item \code{x}: x position of the geometry (when orientation = \code{"vertical"}); or sample data to be summarized
(when \code{orientation = "horizontal"}) except for \code{stat_dist_} geometries (which use only one of \code{x} or \code{y}
at a time along with the \code{dist} aesthetic).
\item \code{y}: y position of the geometry (when orientation = \code{"horizontal"}); or sample data to be summarized
(when \code{orientation = "vertical"}) except for \code{stat_dist_} geometries (which use only one of \code{x} or \code{y}
at a time along with the \code{dist} aesthetic).
}
In addition, in their default configuration (paired with \code{\link[=geom_interval]{geom_interval()}}) the following aesthetics are supported by the underlying geom:

\strong{Slab-specific aesthetics}
\itemize{
\item \code{thickness}: The thickness of the slab at each \code{x} value (if \code{orientation = "horizontal"}) or
\code{y} value (if \code{orientation = "vertical"}) of the slab.
\item \code{side}: Which side to place the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).
\item \code{scale}: What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.
\item \code{justification}: Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to 0.5.
\item \code{datatype}: When using composite geoms directly without a \code{stat} (e.g. \code{\link[=geom_slabinterval]{geom_slabinterval()}}), \code{datatype} is used to
indicate which part of the geom a row in the data targets: rows with \code{datatype = "slab"} target the
slab portion of the geometry and rows with \code{datatype = "interval"} target the interval portion of
the geometry. This is set automatically when using ggdist \code{stat}s.
}
\strong{Interval-specific aesthetics}
\itemize{
\item \code{xmin}: Left end of the interval sub-geometry (if \code{orientation = "horizontal"}).
\item \code{xmax}: Right end of the interval sub-geometry (if \code{orientation = "horizontal"}).
\item \code{ymin}: Lower end of the interval sub-geometry (if \code{orientation = "vertical"}).
\item \code{ymax}: Upper end of the interval sub-geometry (if \code{orientation = "vertical"}).
}
\strong{Point-specific aesthetics}
\itemize{
\item \code{shape}: Shape type used to draw the \strong{point} sub-geometry.
}
\strong{Color aesthetics}
\itemize{
\item \code{colour}: (or \code{color}) The color of the \strong{interval} and \strong{point} sub-geometries.
Use the \code{slab_color}, \code{interval_color}, or \code{point_color} aesthetics (below) to
set sub-geometry colors separately.
\item \code{fill}: The fill color of the \strong{slab} and \strong{point} sub-geometries. Use the \code{slab_fill}
or \code{point_fill} aesthetics (below) to set sub-geometry colors separately.
\item \code{alpha}: The opacity of the \strong{slab}, \strong{interval}, and \strong{point} sub-geometries. Use the \code{slab_alpha},
\code{interval_alpha}, or \code{point_alpha} aesthetics (below) to set sub-geometry colors separately.
\item \code{colour_ramp}: (or \code{color_ramp}) A secondary scale that modifies the \code{color}
scale to "ramp" to another color. See \code{scale_colour_ramp()} for examples.
\item \code{fill_ramp}: (or \code{fill_ramp}) A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{scale_fill_ramp()} for examples.
}
\strong{Line aesthetics}
\itemize{
\item \code{size}: Width of the outline around the \strong{slab} (if visible). Also determines the width of
the line used to draw the \strong{interval} and the size of the \strong{point}, but raw
\code{size} values are transformed according to the \code{interval_size_domain}, \code{interval_size_range},
and \code{fatten_point} parameters of the \code{geom} (see above). Use the \code{slab_size},
\code{interval_size}, or \code{point_size} aesthetics (below) to set sub-geometry line widths separately
(note that when size is set directly using the override aesthetics, interval and point
sizes are not affected by \code{interval_size_domain}, \code{interval_size_range}, and \code{fatten_point}).
\item \code{stroke}: Width of the outline around the \strong{point} sub-geometry.
\item \code{linetype}: Type of line (e.g., \code{"solid"}, \code{"dashed"}, etc) used to draw the \strong{interval}
and the outline of the \strong{slab} (if it is visible). Use the \code{slab_linetype} or
\code{interval_linetype} aesthetics (below) to set sub-geometry line types separately.
}
\strong{Slab-specific color/line override aesthetics}
\itemize{
\item \code{slab_fill}: Override for \code{fill}: the fill color of the slab.
\item \code{slab_colour}: (or \code{slab_color}) Override for \code{colour}/\code{color}: the outline color of the slab.
\item \code{slab_alpha}: Override for \code{alpha}: the opacity of the slab.
\item \code{slab_size}: Override for \code{size}: the width of the outline of the slab.
\item \code{slab_linetype}: Override for \code{linetype}: the line type of the outline of the slab.
}
\strong{Interval-specific color/line override aesthetics}
\itemize{
\item \code{interval_colour}: (or \code{interval_color}) Override for \code{colour}/\code{color}: the color of the interval.
\item \code{interval_alpha}: Override for \code{alpha}: the opacity of the interval.
\item \code{interval_size}: Override for \code{size}: the line width of the interval.
\item \code{interval_linetype}: Override for \code{linetype}: the line type of the interval.
}
\strong{Point-specific color/line override aesthetics}
\itemize{
\item \code{point_fill}: Override for \code{fill}: the fill color of the point.
\item \code{point_colour}: (or \code{point_color}) Override for \code{colour}/\code{color}: the outline color of the point.
\item \code{point_alpha}: Override for \code{alpha}: the opacity of the point.
\item \code{point_size}: Override for \code{size}: the size of the point.
}
\strong{Other aesthetics} (these work as in standard \code{geom}s)
\itemize{
\item \code{width}
\item \code{height}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

theme_set(theme_ggdist())

data(RankCorr_u_tau, package = "ggdist")

RankCorr_u_tau \%>\%
  group_by(i) \%>\%
  ggplot(aes(y = factor(i), x = u_tau)) +
  stat_interval() +
  scale_color_brewer()

RankCorr_u_tau \%>\%
  group_by(i) \%>\%
  ggplot(aes(x = factor(i), y = u_tau)) +
  stat_interval() +
  scale_color_brewer()

}
\seealso{
See \code{\link[=geom_interval]{geom_interval()}} for the geom versions, intended
for use on points and intervals that have already been summarized using a \code{\link[=point_interval]{point_interval()}} function.
See \code{\link[=stat_pointinterval]{stat_pointinterval()}} for a similar stat intended for
point summaries and intervals.
See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} for a variety of other
stats that combine intervals with densities and CDFs.
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for the geom that these geoms wrap. All parameters of that geom are
available to these geoms.
}
