% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drelationship.R
\name{Assess d-separation between variables}
\alias{Assess d-separation between variables}
\alias{node_dconnected}
\alias{node_dseparated}
\alias{node_drelationship}
\alias{ggdag_drelationship}
\alias{ggdag_dseparated}
\alias{ggdag_dconnected}
\title{D-relationship between variables}
\usage{
node_dconnected(.tdy_dag, from = NULL, to = NULL,
  controlling_for = NULL, as_factor = TRUE, ...)

node_dseparated(.tdy_dag, from = NULL, to = NULL,
  controlling_for = NULL, as_factor = TRUE)

node_drelationship(.tdy_dag, from = NULL, to = NULL,
  controlling_for = NULL, as_factor = TRUE)

ggdag_drelationship(.tdy_dag, from = NULL, to = NULL,
  controlling_for = NULL, ..., edge_type = "link_arc",
  node_size = 16, text_size = 3.88, label_size = text_size,
  text_col = "white", label_col = text_col, node = TRUE,
  stylized = FALSE, text = TRUE, use_labels = NULL,
  collider_lines = TRUE)

ggdag_dseparated(.tdy_dag, from = NULL, to = NULL,
  controlling_for = NULL, ..., edge_type = "link_arc",
  node_size = 16, text_size = 3.88, label_size = text_size,
  text_col = "white", label_col = text_col, node = TRUE,
  stylized = FALSE, text = TRUE, use_labels = NULL,
  collider_lines = TRUE)

ggdag_dconnected(.tdy_dag, from = NULL, to = NULL,
  controlling_for = NULL, ..., edge_type = "link_arc",
  node_size = 16, text_size = 3.88, label_size = text_size,
  text_col = "white", label_col = text_col, node = TRUE,
  stylized = FALSE, text = TRUE, use_labels = NULL,
  collider_lines = TRUE)
}
\arguments{
\item{.tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{from}{a character vector, the starting variable (must by in DAG). If
\code{NULL}, checks DAG for exposure variable.}

\item{to}{a character vector, the ending variable (must by in DAG). If
\code{NULL}, checks DAG for outcome variable.}

\item{controlling_for}{a character vector, variables in the DAG to control
for.}

\item{as_factor}{logical. Should the \code{d_relationship} variable be a
factor?}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{edge_type}{a character vector, the edge geom to use. One of:
"link_arc", which accounts for directed and bidirected edges, "link",
"arc", or "diagonal"}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_repel_label()}.
Default is \code{NULL}.}

\item{collider_lines}{logical. Should the plot show paths activated by
adjusting for a collider?}
}
\value{
a \code{tidy_dagitty} with a \code{d_relationship} column for
variable D relationship or a \code{ggplot}
}
\description{
D-separation is a key concept in causal structural models. Variables are
d-separated if there are no open paths between them. The \code{node_d*()}
functions label variables as d-connected or d-separated. The
\code{ggdag_d*()} functions plot the results. The \code{*_dconnected()},
\code{*_dseparated()}, and \code{*_drelationship()} functions essentially
produce the same output and are just different ways of thinking about the
relationship. See \code{\link[dagitty:dseparated]{dagitty::dseparated()}} for details.
}
\examples{
dag <- dagify(m ~ x + y)
dag \%>\% ggdag_drelationship("x", "y")
dag \%>\% ggdag_drelationship("x", "y", controlling_for = "m")

dag \%>\%
  node_dseparated("x", "y") \%>\%
  ggplot(aes(x = x, y = y, xend = xend, yend = yend, shape = adjusted, col = d_relationship)) +
  geom_dag_edges() +
  geom_dag_collider_edges() +
  geom_dag_node() +
  geom_dag_text(col = "white") +
  theme_dag() + scale_adjusted()

dag \%>\%
  node_dconnected("x", "y", controlling_for = "m") \%>\%
  ggplot(aes(x = x, y = y, xend = xend, yend = yend, shape = adjusted, col = d_relationship)) +
  geom_dag_edges() +
  geom_dag_collider_edges() +
  geom_dag_node() +
  geom_dag_text(col = "white") +
  theme_dag() +
  scale_adjusted()

dagify(m ~ x + y, m_jr ~ m) \%>\%
  tidy_dagitty(layout = "nicely") \%>\%
  node_dconnected("x", "y", controlling_for = "m_jr") \%>\%
  ggplot(aes(x = x, y = y, xend = xend, yend = yend, shape = adjusted, col = d_relationship)) +
  geom_dag_edges() +
  geom_dag_collider_edges() +
  geom_dag_node() +
  geom_dag_text(col = "white") +
  theme_dag() +
  scale_adjusted()
}
