% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadTrack.R
\name{LoadTrackFile}
\alias{LoadTrackFile}
\title{Load Track File to Dataframe.}
\usage{
LoadTrackFile(
  track.file,
  track.folder = NULL,
  format = c("bam", "wig", "bw", "bedgraph"),
  meta.info = NULL,
  meta.file = "",
  bamcoverage.path = NULL,
  norm.method = c("RPKM", "CPM", "BPM", "RPGC", "None"),
  single.nuc = FALSE,
  single.nuc.region = NULL,
  bin.size = 10,
  bc.extra.para = NULL
)
}
\arguments{
\item{track.file}{Track file, when \code{track.folder} is not NULL, determined by \code{track.folder}.}

\item{track.folder}{Track file folder. Default: NULL.}

\item{format}{Track file format, chosen from bam, wig, bw(bigwig), bedgraph(bedGraph).}

\item{meta.info}{Track file metadata. The columns should be: SampleName (\code{track.file} without suffix),
Type (sample with replicates information), Group (sample group). when \code{meta.file} is not NULL,
determined by \code{meta.file}.Default: NULL.}

\item{meta.file}{File contains track file metadata. Default: "".}

\item{bamcoverage.path}{The path to \code{bamCoverage}, used when \code{format} is bam. Default: NULL (auto-detect).}

\item{norm.method}{Methods to normalize the number of reads per bin, chosen from "RPKM", "CPM", "BPM", "RPGC", "None".
Default: RPKM.}

\item{single.nuc}{Logical value, whether to visualize at single nucleotide level. Default: FALSE.}

\item{single.nuc.region}{Region for \code{single.nuc}. Default: NULL}

\item{bin.size}{Size of the bins, in bases. Default: 50.}

\item{bc.extra.para}{Extra parameters for \code{bamCoverage}, eg: "--effectiveGenomeSize 2700000000 --ignoreForNormalization chrX"}
}
\value{
A dataframe.
}
\description{
Load Track File to Dataframe.
}
\examples{
library(ggcoverage)
sample.meta <- data.frame(
  SampleName = c("Chr18_MCF7_ER_1", "Chr18_MCF7_ER_2", "Chr18_MCF7_ER_3", "Chr18_MCF7_input"),
  Type = c("MCF7_ER_1", "MCF7_ER_2", "MCF7_ER_3", "MCF7_input"),
  Group = c("IP", "IP", "IP", "Input")
)
# track folder
track.folder <- system.file("extdata", "ChIP-seq", package = "ggcoverage")
# load bigwig file
track.df <- LoadTrackFile(
  track.folder = track.folder, format = "bw",
  meta.info = sample.meta
)
}
