% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{temps}
\alias{temps}
\title{Average Daily Temperatures}
\format{
A data frame (specifically a tbl_df) with 730 rows and 3 variables:
\describe{
\item{\code{city}}{\verb{New York} or \verb{San Francisco}}
\item{\code{date}}{Date in \code{YYYY-MM-DD} format}
\item{\code{avg}}{Average temperature in degrees Fahrenheit (°F) rounded to
the nearest half degree}
}
}
\usage{
temps
}
\description{
A dataset containing daily average temperatures of New York and San Francisco
in 2021 as recorded by the US National Weather Service (NWS) at weather.gov.
}
\details{
It is difficult to pull data from the NWS. It does not provide the data via
an API and the data it returns through its point-and-click interface isn't in
plain text format! To make matters worse, you can only retrieve data from a
city one month at a time.

For San Francisco, visit \url{https://www.weather.gov/wrh/climate?wfo=mtr}
and choose "San Francisco City, CA", "Daily data for a month", and a month
from 2021; for New York, visit \url{https://www.weather.gov/wrh/climate?wfo=okx}
and choose "NY-Central Park Area", "Daily data for a month", and a month from
2021. Copy and paste the data into spreadsheet software for further processing.
}
\examples{
temps
}
\keyword{datasets}
