% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grey_mode.R
\name{grey_mode_r}
\alias{grey_mode_r}
\alias{grey_mode_t}
\alias{grey_mode_b}
\alias{grey_mode_n}
\title{Grey mode theme family}
\usage{
grey_mode_r(
  ...,
  base_size = 11,
  base_family = "",
  base_colour = "#121B24FF",
  axis_line_colour = "#121B24FF",
  axis_line_linewidth = 0.33,
  axis_ticks_colour = axis_line_colour,
  axis_ticks_linewidth = axis_line_linewidth,
  axis_ticks_length_x = grid::unit(base_size/3, "pt"),
  axis_ticks_length_y = grid::unit(base_size/4, "pt"),
  panel_grid_colour = "#F6F8FAFF",
  panel_grid_linewidth = 1.33,
  panel_background_fill = "#FCFDFEFF",
  plot_background_fill = "#F6F8FAFF",
  legend_axis_line_colour = plot_background_fill,
  legend_axis_line_linewidth = 0.33,
  legend_background_fill = plot_background_fill,
  legend_key_fill = plot_background_fill,
  legend_ticks_colour = legend_axis_line_colour,
  legend_ticks_linewidth = legend_axis_line_linewidth,
  legend_ticks_length = ggplot2::rel(c(0.175, 0)),
  orientation = NULL
)

grey_mode_t(
  ...,
  base_size = 11,
  base_family = "",
  base_colour = "#121B24FF",
  axis_line_colour = "#121B24FF",
  axis_line_linewidth = 0.33,
  axis_ticks_colour = axis_line_colour,
  axis_ticks_linewidth = axis_line_linewidth,
  axis_ticks_length_x = grid::unit(base_size/3, "pt"),
  axis_ticks_length_y = grid::unit(base_size/4, "pt"),
  panel_grid_colour = "#F6F8FAFF",
  panel_grid_linewidth = 1.33,
  panel_background_fill = "#FCFDFEFF",
  plot_background_fill = "#F6F8FAFF",
  legend_axis_line_colour = plot_background_fill,
  legend_axis_line_linewidth = 0.33,
  legend_background_fill = plot_background_fill,
  legend_key_fill = plot_background_fill,
  legend_ticks_colour = legend_axis_line_colour,
  legend_ticks_linewidth = legend_axis_line_linewidth,
  legend_ticks_length = ggplot2::rel(c(0.175, 0)),
  orientation = NULL
)

grey_mode_b(
  ...,
  base_size = 11,
  base_family = "",
  base_colour = "#121B24FF",
  axis_line_colour = "#121B24FF",
  axis_line_linewidth = 0.33,
  axis_ticks_colour = axis_line_colour,
  axis_ticks_linewidth = axis_line_linewidth,
  axis_ticks_length_x = grid::unit(base_size/3, "pt"),
  axis_ticks_length_y = grid::unit(base_size/4, "pt"),
  panel_grid_colour = "#F6F8FAFF",
  panel_grid_linewidth = 1.33,
  panel_background_fill = "#FCFDFEFF",
  plot_background_fill = "#F6F8FAFF",
  legend_axis_line_colour = plot_background_fill,
  legend_axis_line_linewidth = 0.33,
  legend_background_fill = plot_background_fill,
  legend_key_fill = plot_background_fill,
  legend_ticks_colour = legend_axis_line_colour,
  legend_ticks_linewidth = legend_axis_line_linewidth,
  legend_ticks_length = ggplot2::rel(c(0.175, 0)),
  orientation = NULL
)

grey_mode_n(
  ...,
  base_size = 11,
  base_family = "",
  base_colour = "#121B24FF",
  axis_line_colour = "#121B24FF",
  axis_line_linewidth = 0.33,
  axis_ticks_colour = axis_line_colour,
  axis_ticks_linewidth = axis_line_linewidth,
  axis_ticks_length_x = grid::unit(base_size/3, "pt"),
  axis_ticks_length_y = grid::unit(base_size/4, "pt"),
  panel_grid_colour = "#F6F8FAFF",
  panel_grid_linewidth = 1.33,
  panel_background_fill = "#FCFDFEFF",
  plot_background_fill = "#F6F8FAFF",
  legend_axis_line_colour = plot_background_fill,
  legend_axis_line_linewidth = 0.33,
  legend_background_fill = plot_background_fill,
  legend_key_fill = plot_background_fill,
  legend_ticks_colour = legend_axis_line_colour,
  legend_ticks_linewidth = legend_axis_line_linewidth,
  legend_ticks_length = ggplot2::rel(c(0.175, 0)),
  orientation = NULL
)
}
\arguments{
\item{...}{Provided to force user argument naming etc.}

\item{base_size}{The base size of the text theme element. Defaults to 11.}

\item{base_family}{The base family of the text theme element. Defaults to "".}

\item{base_colour}{The base colour of the text theme element.}

\item{axis_line_colour}{The colour of the axis.line theme element.}

\item{axis_line_linewidth}{The linewidth of the axis.line theme element.}

\item{axis_ticks_colour}{The colour of the axis.ticks theme element.}

\item{axis_ticks_linewidth}{The linewidth of the axis.ticks theme element.}

\item{axis_ticks_length_x}{The length of the axis.ticks.length.x theme element.}

\item{axis_ticks_length_y}{The length of the axis.ticks.length.y theme element.}

\item{panel_grid_colour}{The colour of the panel.grid theme element.}

\item{panel_grid_linewidth}{The linewidth of the panel.grid theme element.}

\item{panel_background_fill}{The fill (and colour) of the panel.background theme element.}

\item{plot_background_fill}{The fill (and colour) of the plot.background theme element.}

\item{legend_axis_line_colour}{The colour of the legend.axis.line theme element.}

\item{legend_axis_line_linewidth}{The linewidth of the legend.axis.line theme element.}

\item{legend_background_fill}{The fill (and colour) of the legend.background theme element.}

\item{legend_key_fill}{The fill (and colour) of the legend.key theme element.}

\item{legend_ticks_colour}{The colour of the legend.ticks theme element.}

\item{legend_ticks_linewidth}{The linewidth of the legend.ticks theme element.}

\item{legend_ticks_length}{The legend.ticks.length theme element.}

\item{orientation}{The orientation of the plot. Either "x" or "y". Defaults to NULL. Not intended for use with the mode argument of gg_* functions.}
}
\value{
A ggplot theme.
}
\description{
A grey mode family of functions:
\itemize{
\item \code{grey_mode_r()} with legend on right
\item \code{grey_mode_t()} with legend on top
\item \code{grey_mode_b()} with legend on bottom
\item \code{grey_mode_n()} with no legend
}
}
\examples{
library(palmerpenguins)
library(ggplot2)

set_blanket()

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    col = species,
    mode = grey_mode_r()
  )

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    col = species,
    mode = grey_mode_t()
  )

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    col = species,
    mode = grey_mode_b()
  )

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    col = species,
    mode = grey_mode_n()
  )

}
