% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dark_mode.R
\name{dark_mode_t}
\alias{dark_mode_t}
\title{Dark mode theme with top legend}
\usage{
dark_mode_t(base_size = 11, base_family = "", x_title = TRUE, y_title = TRUE)
}
\arguments{
\item{base_size}{The base size of the text. Defaults to 11.}

\item{base_family}{The base family of the text. Defaults to "".}

\item{x_title}{TRUE or FALSE whether to have a x axis title. Defaults to TRUE.}

\item{y_title}{TRUE or FALSE whether to have a y axis title. Defaults to TRUE.}
}
\value{
A ggplot theme.
}
\description{
Dark mode theme for a ggplot visualisation with top legend. It uses the colours from \code{darkness}.
}
\examples{
library(palmerpenguins)
library(ggplot2)

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    col = species,
    mode = dark_mode_t()
  )

}
