#' A blue colour
#'
#' @description A blue colour derived from `viridisLite::mako(9)[5]`
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(blue)
blue <- "#357BA2"

#' A teal colour
#'
#' @description A teal colour derived from the US Census Bureau's Data Visualisation Standards.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(teal)
teal <- "#0095A8"

#' A orange colour
#'
#' @description A orange colour derived from the US Census Bureau's Data Visualisation Standards.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(orange)
orange <- "#FF7043"

#' A navy colour
#'
#' @description A navy colour derived from the US Census Bureau's Data Visualisation Standards. Note this colour is not accessible with dark modes.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(navy)
navy <- "#112E51"

#' A plum colour
#'
#' @description A plum colour inspired by the NZ tree fuchsia (kōtukutuku)
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(plum)
plum <- "#901752"

#' Grey colours
#'
#' @description A vector of grey colours derived from the US Census Bureau's Data Visualisation Standards.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(greys)
greys <- c("#E8EFF2", "#C8D7DF", "#A7C0CD", "#78909C", "#4B636E", "#364850", "#222C31")

#' The `light_mode_*` theme colours
#'
#' @description A vector of colours used in the `light_mode_*` themes.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(lightness)
lightness <- c("#121B24", "#FFFFFF", "#F6F8FA")

#' The `grey_mode_*` theme colours
#'
#' @description A vector of colours used in the `grey_mode_*` themes.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(greyness)
greyness <- c("#121B24", "#fCFDFE", "#F6F8FA")

#' The `dark_mode_*` theme colours
#'
#' @description A vector of colours used in the `dark_mode_*` themes.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(darkness)
darkness <- c("#00040a", "#C8D7DF", "#050D1B")
