% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-step.R, R/view-step-manual.R
\name{view_step}
\alias{view_step}
\alias{view_step_manual}
\title{Follow the data in steps}
\usage{
view_step(
  pause_length = 1,
  step_length = 1,
  nsteps = NULL,
  look_ahead = pause_length,
  delay = 0,
  include = TRUE,
  ease = "cubic-in-out",
  wrap = TRUE,
  pause_first = FALSE,
  fixed_x = FALSE,
  fixed_y = FALSE,
  exclude_layer = NULL,
  aspect_ratio = 1
)

view_step_manual(
  pause_length = 1,
  step_length = 1,
  xmin,
  xmax,
  ymin,
  ymax,
  delay = 0,
  ease = "cubic-in-out",
  wrap = TRUE,
  pause_first = FALSE,
  fixed_x = FALSE,
  fixed_y = FALSE,
  exclude_layer = NULL,
  aspect_ratio = 1
)
}
\arguments{
\item{pause_length}{The relative length the view will be kept static. Will
be recycled to match the number of steps}

\item{step_length}{The relative length the view will use to transition to the
new position. Will be recycled to match the number of steps}

\item{nsteps}{The number of steps. If \code{NULL} it will be set to the max length
of \code{pause_length} or \code{step_length}}

\item{look_ahead}{A relative length to look ahead in the animation to get the
new zoom area. Allow the view to zoom to where the data will be}

\item{delay}{A relative length to switch the view back and forth relative to
the actual frames. E.g. if delay is calculated to 5 frames, frame 6 will get
the view intended for frame 1.}

\item{include}{Should the steps include both the start and end frame range}

\item{ease}{The easing function used for the step}

\item{wrap}{As in \code{\link[=transition_states]{transition_states()}}. Should the view wrap around and zoom
back to the first state.}

\item{pause_first}{Should the view start with a pause. The default is to
start with a step so that it is aligned to the static period in
\code{\link[=transition_states]{transition_states()}}}

\item{fixed_x}{Either a logical indicating if the dimension should
not be modified by the view, or a numeric vector giving the lower and upper
bounds of the dimension. For the latter, an \code{NA} value will be substituted
for whatever is calculated by the view (e.g. \code{fixed_x = c(0, NA)}) will fix
the minimum x value to 0 and let the view calculate the upper bound.}

\item{fixed_y}{Either a logical indicating if the dimension should
not be modified by the view, or a numeric vector giving the lower and upper
bounds of the dimension. For the latter, an \code{NA} value will be substituted
for whatever is calculated by the view (e.g. \code{fixed_x = c(0, NA)}) will fix
the minimum x value to 0 and let the view calculate the upper bound.}

\item{exclude_layer}{Integer vector of layer indices that should be ignored
when calculating the view}

\item{aspect_ratio}{If the coord is fixed, ensure that the view matches the
given aspect ratio. Will override anything given in \code{fixed_x}/\code{fixed_y}}

\item{xmin, xmax, ymin, ymax}{Vectors of even length defining the boundaries of
the different views to go through}
}
\description{
This view is a bit like \code{\link[=view_follow]{view_follow()}} but will not match the data in each
frame. Instead it will switch between being static and zoom to the range of
the data. It is a great pairing with \code{\link[=transition_states]{transition_states()}} as it can move the
view while the data is static and then be static while the data moves. The
standard version will look at the data present in the calculated frames and
set the ranges based on that, while the \verb{_manual} version will allow you to
define your own ranges.
}
\examples{
anim <- ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_point() +
  transition_states(Species, transition_length = 2, state_length = 1) +
  view_step(pause_length = 2, step_length = 1, nsteps = 3)

# Default is to include the data from the two states you're stepping between
# but this can be turned off
anim <- ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_point() +
  transition_states(Species, transition_length = 2, state_length = 1) +
  view_step(pause_length = 2, step_length = 1, nsteps = 3, include = FALSE)

# Default is to work off-beat of transition_states so that view changes while
# data is static. Setting pause_first=TRUE changes this
anim <- ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_point() +
  transition_states(Species, transition_length = 2, state_length = 1) +
  view_step(pause_length = 1, step_length = 2, nsteps = 3, pause_first = TRUE)

# If the transition doesn't wrap, then the view shouldn't either
anim <- ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_point() +
  transition_states(Species, transition_length = 2, state_length = 1, wrap = FALSE) +
  view_step(pause_length = 2, step_length = 1, nsteps = 3, wrap = FALSE)

}
\seealso{
Other views: 
\code{\link{view_follow}()},
\code{\link{view_static}()},
\code{\link{view_zoom}()}
}
\concept{views}
