% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-follow.R
\name{view_follow}
\alias{view_follow}
\title{Let the view follow the data in each frame}
\usage{
view_follow(fixed_x = FALSE, fixed_y = FALSE, exclude_layer = NULL,
  aspect_ratio = 1)
}
\arguments{
\item{fixed_x, fixed_y}{Either a logical indicating if the dimension should
not be modified by the view, or a numeric vector giving the lower and upper
bounds of the dimension. For the latter, an \code{NA} value will be substituted
for whatever is calculated by the view (e.g. \code{fixed_x = c(0, NA)}) will fix
the minimum x value to 0 and let the view calculate the upper bound.}

\item{exclude_layer}{Integer vector of layer indices that should be ignored
when calculating the view}

\item{aspect_ratio}{If the coord is fixed, ensure that the view matches the
given aspect ratio. Will override anything given in \code{fixed_x}/\code{fixed_y}}
}
\description{
This view will set the panels to include the data present in the frame.
}
\examples{
anim <- ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
  geom_point() +
  labs(title = "{closest_state}") +
  transition_states(Species, transition_length = 4, state_length = 1) +
  view_follow()

# Fixing a dimension can be done in general
anim1 <- ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
  geom_point() +
  labs(title = "{closest_state}") +
  transition_states(Species, transition_length = 4, state_length = 1) +
  view_follow(fixed_x = TRUE)

# ...or just for one side of the range
anim1 <- ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
  geom_point() +
  labs(title = "{closest_state}") +
  transition_states(Species, transition_length = 4, state_length = 1) +
  view_follow(fixed_x = c(4, NA), fixed_y = c(2, NA))

}
\seealso{
Other views: \code{\link{view_static}},
  \code{\link{view_step}}, \code{\link{view_zoom}}
}
\concept{views}
