% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-stratum.r
\name{stat_stratum}
\alias{stat_stratum}
\title{Stratum positions}
\usage{
stat_stratum(mapping = NULL, data = NULL, geom = "stratum",
  position = "identity", decreasing = NA, reverse = TRUE,
  discern = FALSE, label.strata = FALSE, show.legend = NA,
  inherit.aes = TRUE, na.rm = FALSE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{geom}{The geometric object to use display the data;
override the default.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{decreasing}{Logical; whether to arrange the strata at each axis
in the order of the variable values (\code{NA}, the default),
in ascending order of total weight (largest on top, \code{FALSE}), or
in descending order of total weight (largest on bottom, \code{TRUE}).}

\item{reverse}{Logical; if \code{decreasing} is \code{NA},
whether to arrange the strata at each axis
in the reverse order of the variable values,
so that they match the order of the values in the legend.
Ignored if \code{decreasing} is not \code{NA}.
Defaults to \code{TRUE}.}

\item{discern}{Passed to \code{\link{to_lodes}} if \code{data} is in alluvia
format.}

\item{label.strata}{Logical; whether to assign the values of the axis 
variables to the strata. Defaults to FALSE, and requires that no
\code{label} aesthetic is assigned.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{...}{Additional arguments passed to \code{\link[ggplot2]{layer}}.}
}
\description{
Given a dataset with alluvial structure, \code{stat_stratum} calculates the
centroids of the strata at each axis, together with their weights (heights).
}
\section{Aesthetics}{

\code{stat_alluvium}, \code{stat_flow}, and \code{stat_stratum} require one
of two sets of aesthetics:
\itemize{
  \item \strong{\code{x}} and at least one of
        \strong{\code{alluvium}} and \strong{\code{stratum}}
  \item any number of \strong{\code{axis[0-9]*}}
        (\code{axis1}, \code{axis2}, etc.)
}
Use \code{x}, \code{alluvium}, and/or \code{stratum} for data in lodes format
and \code{axis[0-9]*} for data in alluvia format
(see \code{\link{is_alluvial}}).
Arguments to parameters inconsistent with the format will be ignored.
Additionally, each \code{stat_*} layer accepts the following optional
aesthetics:
\itemize{
  \item \code{weight}
  \item \code{group}
}
\code{weight} controls the vertical dimensions of the alluvia
and are aggregated across equivalent observations.
\code{group} is used internally; arguments are ignored.
Finally, \code{stat_stratum} accepts the following optional aesthetic:
\itemize{
  \item \code{label}
}
\code{label} is used to label the strata and must take a unique value across
the observations within each stratum.
These and any other aesthetics are aggregated as follows:
Numeric aesthetics, including \code{weight}, are summed.
Character and factor aesthetics, including \code{label},
are assigned to strata provided they take unique values across the
observations within each stratum (otherwise \code{NA} is assigned).
}

\examples{
# only 'stratum' assignment is necessary to generate strata
data(vaccinations)
ggplot(vaccinations,
       aes(weight = freq,
           x = survey, stratum = response,
           fill = response)) +
  stat_stratum(width = .5)

# lode data: positioning with weight labels
ggplot(vaccinations,
       aes(weight = freq,
           x = survey, stratum = response, alluvium = subject,
           label = freq)) +
  stat_stratum(geom = "errorbar") +
  geom_text(stat = "stratum")
# lode data: positioning with stratum labels
ggplot(vaccinations,
       aes(weight = freq,
           x = survey, stratum = response, alluvium = subject,
           label = response)) +
  stat_stratum(geom = "errorbar") +
  geom_text(stat = "stratum")

# alluvium data: positioning with weight labels
ggplot(as.data.frame(Titanic),
       aes(weight = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age, axis4 = Survived,
           label = Freq)) +
  geom_text(stat = "stratum") +
  stat_stratum(geom = "errorbar") +
  scale_x_continuous(breaks = 1:4,
                     labels = c("Class", "Sex", "Age", "Survived"))
# alluvium data: positioning with stratum labels
ggplot(as.data.frame(Titanic),
       aes(weight = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age, axis4 = Survived)) +
  geom_text(stat = "stratum", label.strata = TRUE) +
  stat_stratum(geom = "errorbar") +
  scale_x_continuous(breaks = 1:4,
                     labels = c("Class", "Sex", "Age", "Survived"))
}
\seealso{
\code{\link[ggplot2]{layer}} for additional arguments and
  \code{\link{geom_stratum}} for the corresponding geom.

Other alluvial stat layers: \code{\link{stat_alluvium}},
  \code{\link{stat_flow}}
}
