% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gg_minimal_depth.R
\name{plot.gg_minimal_depth}
\alias{plot.gg_minimal_depth}
\title{Plot a \code{\link{gg_minimal_depth}} object for random forest variable ranking.}
\usage{
\method{plot}{gg_minimal_depth}(x, selection = FALSE, type = c("named",
  "rank"), lbls, ...)
}
\arguments{
\item{x}{\code{\link{gg_minimal_depth}} object created from a 
\code{\link[randomForestSRC]{rfsrc}} object}

\item{selection}{should we restrict the plot to only include variables selected by the 
minimal depth criteria (boolean).}

\item{type}{select type of y axis labels c("named","rank")}

\item{lbls}{a vector of alternative variable names.}

\item{...}{optional arguments passed to \code{\link{gg_minimal_depth}}}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_minimal_depth}} object for random forest variable ranking.
}
\examples{
\dontrun{
## Examples from RFSRC package... 
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## -------- iris data
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# varsel_iris <- var.select(rfsrc_iris)
# ... or load a cached randomForestSRC object
data(varsel_iris, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_minimal_depth(varsel_iris)

# Plot the gg_minimal_depth object
plot(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
## -------- air quality data
# rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
# varsel_airq <- var.select(rfsrc_airq)
# ... or load a cached randomForestSRC object
data(varsel_airq, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_minimal_depth(varsel_airq)

# Plot the gg_minimal_depth object
plot(gg_dta)

## -------- Boston data
data(varsel_Boston, package="ggRandomForests")

# Get a data.frame containing error rates
plot(gg_minimal_depth(varsel_Boston))

## -------- mtcars data
data(varsel_mtcars, package="ggRandomForests")

# Get a data.frame containing error rates
plot.gg_minimal_depth(varsel_mtcars)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## -------- veteran data
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# rfsrc_veteran <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
# varsel_veteran <- var.select(rfsrc_veteran)
# Load a cached randomForestSRC object
data(varsel_veteran, package="ggRandomForests")

gg_dta <- gg_minimal_depth(varsel_veteran)
plot(gg_dta)

## -------- pbc data
data(varsel_pbc, package="ggRandomForests")

gg_dta <- gg_minimal_depth(varsel_pbc)
plot(gg_dta)

}

}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R, 
Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2014). Random Forests for Survival, 
Regression and Classification (RF-SRC), R package version 1.5.
}
\seealso{
\code{\link[randomForestSRC]{var.select}} \code{\link{gg_minimal_depth}}
}

