% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gg_minimal_vimp.ggRandomForests.R
\name{gg_minimal_vimp.ggRandomForests}
\alias{gg_minimal_vimp}
\alias{gg_minimal_vimp.ggRandomForests}
\title{Minimal depth vs VIMP camparison by variable rankings.}
\usage{
gg_minimal_vimp.ggRandomForests(object, event, ...)
}
\arguments{
\item{object}{A \code{randomForestSRC::rfsrc} object, \code{randomForestSRC::predict}
object or the list from the \code{randomForestSRC::var.select.rfsrc} function.}

\item{event}{an optional vector of logical values (event indicator) for
shaping the points in when plotting.}

\item{...}{optional arguments passed to the \code{randomForestSRC::var.select} function
 if operating on an \code{randomForestSRC::rfsrc} object.}
}
\value{
\code{gg_minimal_vimp} comparison object.
}
\description{
Minimal depth vs VIMP camparison by variable rankings.
}
\examples{
## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# varsel_iris <- var.select(rfsrc_iris)
# ... or load a cached randomForestSRC object
data(varsel_iris, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_minimal_vimp(varsel_iris)

# Plot the gg_mkinimal_depth object
plot(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
# varsel_airq <- var.select(rfsrc_airq)
# ... or load a cached randomForestSRC object
data(varsel_airq, package="ggRandomForests")

# Get a data.frame containing error rates
gg_dta<- gg_minimal_vimp(varsel_airq)

# Plot the gg_error object
plot(gg_dta)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# rfsrc_veteran <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
# varsel_veteran <- var.select(rfsrc_veteran)
# Load a cached randomForestSRC object
data(varsel_veteran, package="ggRandomForests")

gg_dta <- gg_minimal_vimp(varsel_veteran)
plot(gg_dta)
}
\seealso{
\code{\link{plot.gg_minimal_vimp}} \code{randomForestSRC::var.select}
}

