% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_minimal_depth.ggRandomForests}
\alias{gg_minimal_depth}
\alias{gg_minimal_depth.ggRandomForests}
\title{Minimal depth data object (\code{randomForestSRC::var.select})}
\usage{
gg_minimal_depth.ggRandomForests(object, ...)
}
\arguments{
\item{object}{A \code{randomForestSRC::rfsrc} object, \code{randomForestSRC::predict}
object or the list from the \code{randomForestSRC::var.select.rfsrc} function.}

\item{...}{optional arguments passed to the \code{randomForestSRC::var.select} function
 if operating on an \code{randomForestSRC::rfsrc} object.}
}
\value{
Invisibly, the modified list of variables from the
\code{randomForestSRC::var.select.rfsrc} function, ordered by minimal depth rank.
}
\description{
the \code{randomForestSRC::var.select} function implements
random forest variable selection using tree minimal depth methodology. The
gg_minimal_depth
function takes the output from \code{randomForestSRC::var.select} and creates a
\code{data.frame} formatted for the \code{\link{plot.gg_minimal_depth}} function.
}
\examples{
## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## You can build a randomForest
# iris_rf <- rfsrc(Species ~ ., data = iris)
# iris_vs <- var.select(iris_rf)
# ... or load a cached randomForestSRC object
data(iris_vs, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
ggrf.obj<- gg_minimal_depth(iris_vs)

# Plot the gg_mkinimal_depth object
plot(ggrf.obj)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# airq_rf <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
# airq_vs <- var.select(airq_rf)
# ... or load a cached randomForestSRC object
data(airq_vs, package="ggRandomForests")

# Get a data.frame containing error rates
ggrf.obj<- gg_minimal_depth(airq_vs)

# Plot the gg_error object
plot(ggrf.obj)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
# veteran_vs <- var.select(veteran_rf)
# Load a cached randomForestSRC object
data(veteran_vs, package="ggRandomForests")

ggrf.obj <- gg_minimal_depth(veteran_vs)
plot(ggrf.obj)
}
\seealso{
\code{randomForestSRC::var.select} \code{\link{plot.gg_minimal_depth}}
}

