% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotCount.R
\name{plotCount}
\alias{plotCount}
\title{Plot count data with ggplot2}
\usage{
plotCount(x)
}
\arguments{
\item{x}{A data.frame or table. See 'Details' for more information.}
}
\value{
A ggplot2 object that can be have more layers added onto it.
}
\description{
Create a bar plot of count (frequency) data that is stored in a data.frame
or table.
}
\details{
The argument to this function is expected to be either a data.frame or a
table.

If a data.frame is provided, it must have exactly two columns:
the first column contains the of unique values in the data, and the second
column is the corresponding integer frequencies to each value.

If a table is provided, it must have exactly one row: the rownames are the
unique values in the data, and the row values are the  corresponding integer
frequencies to each value.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  plotCount(table(infert$education))
  df <- data.frame("vehicle" = c("bicycle", "car", "unicycle", "Boeing747"),
                   "NumWheels" = c(2, 4, 1, 16))
  plotCount(df) + removeGridX()
}
}

