% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparallel_options.R
\name{ggparallel_options}
\alias{ggparallel_options}
\title{Visual Parameters for ggparallel Plots}
\usage{
ggparallel_options(
  show_legend = TRUE,
  show_legend_titles = FALSE,
  legend_position = c("bottom", "right", "left", "top"),
  legend_title_position = c("left", "top", "bottom", "right"),
  legend_nrow = NULL,
  legend_ncol = NULL,
  legend_key_size = 1,
  beautify_text = TRUE,
  max_digits_bounds = 1,
  x_axis_text_angle = 90,
  x_axis_text_hjust = 0,
  x_axis_text_vjust = 0.5,
  fontsize_x_axis_text = 12,
  show_column_names = TRUE,
  show_points = FALSE,
  show_bounds_labels = FALSE,
  show_bounds_rect = FALSE,
  line_alpha = 0.5,
  line_width = NULL,
  line_type = 1,
  x_axis_gridlines = ggplot2::element_line(colour = "black"),
  interactive_svg_width = NULL,
  interactive_svg_height = NULL
)
}
\arguments{
\item{show_legend}{Display the legend on the plot (flag).}

\item{show_legend_titles}{Display titles for legends (flag).}

\item{legend_position}{Position of the legend ("right", "left", "bottom", "top").}

\item{legend_title_position}{Position of the legend title ("top", "bottom", "left", "right").}

\item{legend_nrow}{Number of rows in the legend (number).}

\item{legend_ncol}{Number of columns in the legend. If set, \code{legend_nrow} should be \code{NULL} (number).}

\item{legend_key_size}{Size of the legend key symbols. (number).}

\item{beautify_text}{Beautify y-axis text and legend titles by capitalizing words and adding spaces (flag).}

\item{max_digits_bounds}{Number of digits to round the axis bounds label text to (number)}

\item{x_axis_text_angle}{Angle of the x axis text describing column names (number)}

\item{x_axis_text_hjust}{Horizontal Justification of the x axis text describing column names (number)}

\item{x_axis_text_vjust}{Vertical Justification of the x axis text describing column names (number)}

\item{fontsize_x_axis_text}{fontsize of the x-axis text describing column names (number)}

\item{show_column_names}{Show column names as x axis text (flag)}

\item{show_points}{Show points (flag)}

\item{show_bounds_labels}{Show bounds (min and max value) of each feature with labels above / below the axes (flag)}

\item{show_bounds_rect}{Show bounds (min and max value) of each feature with a rectangular graphic (flag)}

\item{line_alpha}{Alpha of line geom (number)}

\item{line_width}{Width of the line geom (number)}

\item{line_type}{Type of line geom (number or string. see \code{\link[ggplot2:aes_linetype_size_shape]{ggplot2::aes_linetype_size_shape()}} for valid options)}

\item{x_axis_gridlines}{Customise look of x axis gridlines. Must be either a call to \code{\link[ggplot2:element]{ggplot2::element_line()}} or \code{\link[ggplot2:element]{ggplot2::element_blank()}}.}

\item{interactive_svg_width, interactive_svg_height}{Width and height of the interactive graphic region (in inches). Only used when \code{interactive = TRUE}.}
}
\value{
A list of visualization parameters for \code{ggparallel}.
}
\description{
Configures aesthetic and layout settings for plots generated by \code{ggparallel}.
}
\examples{
ggparallel(
  data = minibeans,
  col_colour = "Class",
  order_columns_by = "auto"
)

ggparallel(
  data = minibeans,
  col_colour = "Class",
  highlight = "DERMASON",
  order_columns_by = "auto"
)

# Customise appearance using options argument
ggparallel(
  data = minibeans,
  col_colour = "Class",
  order_columns_by = "auto",
  options = ggparallel_options(show_legend = FALSE)
)

}
