% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiSummary}
\alias{gfiSummary}
\title{Summary of fiducial samples}
\usage{
gfiSummary(fidsamples, conf = 0.95)
}
\arguments{
\item{fidsamples}{fiducial samples, the output of \code{\link{gfilinreg}} or 
\code{\link{gfilinregPredictive}}}

\item{conf}{confidence level}
}
\value{
A matrix with summary statistics: means, medians, and confidence 
  intervals.
}
\description{
Summary of the fiducial samples.
}
\examples{
set.seed(666L)
dat <- data.frame(
  group = gl(2, 15), 
  y = c(2*rlogis(15L), 10 + 2*rlogis(15L))
)
gfi <- gfilinreg(y ~ 0 + group, distr = "logistic", data = dat, L = 30L)
gfiSummary(gfi)
}
