% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMB_stabpath.R
\name{CMB.stabpath}
\alias{CMB.stabpath}
\title{CMB stability paths}
\usage{
CMB.stabpath(
  D,
  nsing,
  Bsing = 1,
  alpha = 1,
  singfam = Gaussian(),
  evalfam = Gaussian(),
  sing = FALSE,
  Mseq,
  m_iter = 100,
  kap = 0.1,
  LS = FALSE,
  best = 1,
  wagg,
  robagg = FALSE,
  lower = 0,
  B,
  ncmb,
  ...
)
}
\arguments{
\item{D}{Data matrix. Has to be an \eqn{n \times (p+1)-}dimensional data frame in the format \eqn{(X,Y)}. The \eqn{X-}part must not
contain an intercept column containing only ones since this column will be added automatically.}

\item{nsing}{Number of observations (rows) used for the SingBoost submodels.}

\item{Bsing}{Number of subsamples based on which the SingBoost models are validated. Default is 1. Not to confuse with parameter \code{B} for the Stability Selection.}

\item{alpha}{Optional real number in \eqn{]0,1]}. Defines the fraction of best SingBoost models used in the aggregation step. Default is 1 (use all models).}

\item{singfam}{A SingBoost family. The SingBoost models are trained based on the corresponding loss function. Default is \code{Gaussian()} (squared loss).}

\item{evalfam}{A SingBoost family. The SingBoost models are validated according to the corresponding loss function. Default is \code{Gaussian()} (squared loss).}

\item{sing}{If \code{sing=FALSE} and the \code{singfam} family is a standard Boosting family that is contained in the package
\code{mboost}, the CMB aggregation procedure is executed for the corresponding standard Boosting models.}

\item{Mseq}{A vector of different values for \eqn{M}.}

\item{m_iter}{Number of SingBoost iterations. Default is 100.}

\item{kap}{Learning rate (step size). Must be a real number in \eqn{]0,1]}. Default is 0.1 It is recommended to use
a value smaller than 0.5.}

\item{LS}{If a \code{singfamily} object that is already provided by \code{mboost} is used, the respective Boosting algorithm
will be performed in the singular iterations if \code{Ls} is set to \code{TRUE}. Default is \code{FALSE}.}

\item{best}{Needed in the case of localized ranking. The parameter \code{K} of the localized ranking loss will be
computed by \eqn{best \cdot n} (rounded to the next larger integer). Warning: If a parameter \code{K} is inserted into the
\code{LocRank} family, it will be ignored when executing SingBoost.}

\item{wagg}{Type of row weight aggregation. \code{'weights1'} indicates that the selection frequencies of the (best)
SingBoost models are averaged. \code{'weights2'} respects the validation losses for each model and downweights the ones
with higher validation losses.}

\item{robagg}{Optional. If setting \code{robagg=TRUE}, the best SingBoost models are ignored when executing the
aggregation to avoid inlier effects. Only reasonable in combination with \code{lower}.}

\item{lower}{Optional argument. Only reasonable when setting \code{robagg=TRUE}. \code{lower} is a real number in \eqn{[0,1[} (a rather
small number is recommended) and indicates that the aggregation ignores the SingBoost models with the best
performances to avoid possible inlier effects.}

\item{B}{Number of subsamples of size \eqn{n_{cmb}} of the training data for CMB aggregation.}

\item{ncmb}{Number of samples used for \code{CMB}. Integer that must be smaller than the number of samples in \code{Dtrain}.}

\item{...}{Optional further arguments}
}
\value{
\item{relev}{List of relevant variables (represented as their column number).}
\item{ind}{Vector of relevant variables (represented as their column number).}
}
\description{
{Draws a Stability plot for CMB.}
}
\references{
{Werner, T., Gradient-Free Gradient Boosting, PhD Thesis, Carl von Ossietzky University Oldenburg, 2020}
}
