% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsat_scenes_files.R
\name{lsat_scene_files}
\alias{lsat_scene_files}
\title{List files for a Landsat scene}
\usage{
lsat_scene_files(x, ...)
}
\arguments{
\item{x}{(character) A URL to a scene html file}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
A data.frame with two columns:
\itemize{
\item file - file name
\item size - file size
}
}
\description{
List files for a Landsat scene
}
\details{
This function fetches files available in a scene, while
\code{\link[=lsat_scenes]{lsat_scenes()}} lists the scenes, but not their files
}
\examples{
\dontrun{
res <- lsat_scenes(n_max = 10)
lsat_scene_files(x = res$download_url[1])
lsat_scene_files(x = res$download_url[2])
}
}
\seealso{
\code{\link[=lsat_scenes]{lsat_scenes()}}
}
