% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.R
\name{commit}
\alias{commit}
\alias{git_commit}
\alias{git_commit_all}
\alias{git_add}
\alias{git_rm}
\alias{git_status}
\alias{git_ls}
\alias{git_log}
\alias{git_reset}
\title{Stage and commit changes}
\usage{
git_commit(message, author = NULL, committer = NULL, repo = ".")

git_commit_all(message, author = NULL, committer = NULL, repo = ".")

git_add(files, force = FALSE, repo = ".")

git_rm(files, repo = ".")

git_status(repo = ".")

git_ls(repo = ".")

git_log(ref = "HEAD", max = 100, repo = ".")

git_reset(type = c("soft", "hard", "mixed"), ref = "HEAD",
  repo = ".")
}
\arguments{
\item{message}{a commit message}

\item{author}{A \link{git_signature} value, default is \link{git_signature_default}.}

\item{committer}{A \link{git_signature} value, default is same as \code{author}}

\item{repo}{a path to an existing repository, or a \code{git_repository} object as
returned by \link{git_open},  \link{git_init} or \link{git_clone}.}

\item{files}{vector of paths relative to the git root directory.
Use \code{"."} to stage all changed files.}

\item{force}{add files even if in gitignore}

\item{ref}{string with a branch/tag/commit}

\item{max}{lookup at most latest n parent commits}

\item{type}{must be one of \code{"soft"}, \code{"hard"}, or \code{"mixed"}}
}
\description{
To commit changes, start with \emph{staging} the files to be included
in the commit using \code{\link[=git_add]{git_add()}} or \code{\link[=git_rm]{git_rm()}}. Use \code{\link[=git_status]{git_status()}} to see an
overview of staged and unstaged changes, and finally \code{\link[=git_commit]{git_commit()}} creates
a new commit with currently staged files.

\link{git_commit_all} is a shorthand that will automatically stage all new and
modified files and then commit.

Also \code{\link[=git_log]{git_log()}} shows the most recent commits and \code{\link[=git_ls]{git_ls()}} lists
all the files that are being tracked in the repository.
}
\seealso{
Other git: \code{\link{branch}}, \code{\link{fetch}},
  \code{\link{git_config}}, \code{\link{repository}},
  \code{\link{signature}}
}
\concept{git}
