% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUGerm.R
\name{CUGerm}
\alias{CUGerm}
\title{Coefficient of uniformity of germination}
\usage{
CUGerm(germ.counts, intervals, partial = TRUE)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
The value of the coefficient of uniformity of germination as
  \mjseqn{\mathrm{time^{-2}}}.
}
\description{
Compute the Coefficient of uniformity of germination (CUG).
}
\details{
CUG is computed as follows
\insertCite{heydecker_seed_1972,bewley_seeds_1994}{germinationmetrics}.
\loadmathjax

\mjsdeqn{CUG =
\frac{\sum_{i=1}^{k}N_{i}}{\sum_{i=1}^{k}(\overline{T}-T_{i})^{2}N_{i}}}

Where, \mjseqn{\overline{T}} is the the mean germination time, \mjseqn{T_{i}}
is the time from the start of the experiment to the \mjseqn{i}th interval,
\mjseqn{N_{i}} is the number of seeds germinated in the \mjseqn{i}th time
interval (not the accumulated number, but the number corresponding to the
\mjseqn{i}th interval), and \mjseqn{k} is the total number of time intervals.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
CUGerm(germ.counts = x, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
CUGerm(germ.counts = y, intervals = int, partial = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[germinationmetrics]{GermSynchrony}},
  \code{\link[germinationmetrics]{MeanGermTime}}
}
