% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUGerm.R
\name{CUGerm}
\alias{CUGerm}
\title{Coefficient of uniformity of germination}
\usage{
CUGerm(germ.counts, intervals, partial = TRUE)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial or
cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
The value of the coefficient of uniformity of germination as
 \ifelse{html}{\out{time<sup>-2</sup>}}{\eqn{\mathrm{time^{-2}}}}.
}
\description{
Compute the coefficient of uniformity of germination (CUG).
}
\details{
CUG is computed as follows (Heydecker, 1973, Bewley and Black, 1994).

\ifelse{html}{\out{<p style="text-align: center;"><i>CUG =
<sup>&sum;<sup>k</sup><sub style="line-height: 1.8; margin-left:
-1ex;">i=1</sub> N<sub>i</sub></sup> &frasl; <sub>&sum;<sup>k</sup><sub
style="line-height: 1.8; margin-left: -1ex;">i=1</sub>(<span
style="text-decoration:overline">T</span> &minus;
T<sub>i</sub>)<sup>2</sup>N<sub>i</sub></sub></i></p>}}{\deqn{CUG =
\frac{\sum_{i=1}^{k}N_{i}}{\sum_{i=1}^{k}(\overline{T}-T_{i})^{2}N_{i}}}}

Where, \ifelse{html}{\out{<i><span style="text-decoration:
overline">T</span></i>}}{\eqn{\overline{T}}} is the the mean germination time,
\ifelse{html}{\out{<i>T<sub>i</sub></i>}}{\eqn{T_{i}}} is the time from the
start of the experiment to the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th
observation (day for the example);
\ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number of seeds
germinated in the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (not the
accumulated number, but the number correspondent to the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation), and
\ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last time of germination.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
CUGerm(germ.counts = x, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
CUGerm(germ.counts = y, intervals = int, partial = FALSE)

}
\references{
\insertRef{heydecker_seed_1972}{germinationmetrics}

\insertRef{bewley_seeds:_1994}{germinationmetrics}
}
\seealso{
\code{\link[germinationmetrics]{GermSynchrony}},
 \code{\link[germinationmetrics]{MeanGermTime}}
}
