% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSCoverageBand.R
\docType{class}
\name{GSCoverageBand}
\alias{GSCoverageBand}
\title{Geoserver REST API GSCoverageBand}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling a GeoServer coverage band
}
\description{
Geoserver REST API GSCoverageBand

Geoserver REST API GSCoverageBand
}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate a \code{GSCoverageBand}
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a \code{GSCoverageBand} from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a \code{GSCoverageBand} to XML
 }
 \item{\code{setDefinition(definition)}}{
   Sets the coverage band definition
 }
 \item{\code{setIndex(index)}}{
   Sets the coverage band index
 }
 \item{\code{setCompositionType}}{
   Sets the composition type. Only 'BAND_SELECT' is supported by GeoServer for now.
 }
 \item{\code{addInputBand(band)}}{
   Adds a input coverage band, object of class \code{GSInputCoverageBand}
 }
 \item{\code{delInputBand(band)}}{
   Removes a input coverage band, object of class \code{GSInputCoverageBand}
 }
}
}

\examples{
GSCoverageBand$new()


}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{coverageBand}
\keyword{geoserver}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSCoverageBand}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{inputCoverageBands}}{list of input coverage bands}

\item{\code{definition}}{coverage band definition}

\item{\code{index}}{coverage band index}

\item{\code{compositionType}}{coverage band composition type}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSCoverageBand-new}{\code{GSCoverageBand$new()}}
\item \href{#method-GSCoverageBand-decode}{\code{GSCoverageBand$decode()}}
\item \href{#method-GSCoverageBand-setName}{\code{GSCoverageBand$setName()}}
\item \href{#method-GSCoverageBand-setDefinition}{\code{GSCoverageBand$setDefinition()}}
\item \href{#method-GSCoverageBand-setIndex}{\code{GSCoverageBand$setIndex()}}
\item \href{#method-GSCoverageBand-setCompositionType}{\code{GSCoverageBand$setCompositionType()}}
\item \href{#method-GSCoverageBand-addInputBand}{\code{GSCoverageBand$addInputBand()}}
\item \href{#method-GSCoverageBand-delInputBand}{\code{GSCoverageBand$delInputBand()}}
\item \href{#method-GSCoverageBand-clone}{\code{GSCoverageBand$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-new}{}}}
\subsection{Method \code{new()}}{
Initalizes a \link{GSCoverageBand}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[xml2]{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[xml2]{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-setName"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-setDefinition"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-setDefinition}{}}}
\subsection{Method \code{setDefinition()}}{
Set definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$setDefinition(definition)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{definition}}{definition}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-setIndex"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-setIndex}{}}}
\subsection{Method \code{setIndex()}}{
Set index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$setIndex(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-setCompositionType"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-setCompositionType}{}}}
\subsection{Method \code{setCompositionType()}}{
Set composition type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$setCompositionType(compositionType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compositionType}}{composition type}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-addInputBand"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-addInputBand}{}}}
\subsection{Method \code{addInputBand()}}{
Adds an input band
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$addInputBand(band)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{band}}{object of class \link{GSInputCoverageBand}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-delInputBand"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-delInputBand}{}}}
\subsection{Method \code{delInputBand()}}{
Deletes an input band
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$delInputBand(band)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{band}}{object of class \link{GSInputCoverageBand}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSCoverageBand-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSCoverageBand-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSCoverageBand$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
