% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSGeoPackageDataStore.R
\docType{class}
\name{GSGeoPackageDataStore}
\alias{GSGeoPackageDataStore}
\title{Geoserver REST API GeoPackageDataStore}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer GeoPackage dataStore
}
\description{
Geoserver REST API GeoPackageDataStore

Geoserver REST API GeoPackageDataStore
}
\section{Methods inherited from \code{GSAbstractDBDataStore}}{

\describe{
   \item{\code{setDatabaseType(dbtype)}}{
     Sets the database type, here "geopkg
   }
   \item{\code{setNamespace(namespace)}}{
     Sets the datastore namespace
   }
   \item{\code{setHost(host)}}{
     Sets the database host
   }
   \item{\code{setPort(port)}}{
     Set the database port
   }
   \item{\code{setDatabase(database)}}{
     Set the database name
   }
   \item{\code{setSchema(schema)}}{
     Set the database schema
   }
   \item{\code{setUser(user)}}{
     Set the database username
   }
   \item{\code{setPassword(password)}}{
     Set the database password
   }
   \item{\code{setJndiReferenceName(jndiReferenceName)}}{
     Set a JNDI reference name
   }
   \item{\code{setExposePrimaryKeys(exposePrimaryKeys)}}{
     Set TRUE if primary keys have to be exposed to datastore, FALSE otherwise.
   }
   \item{\code{setMaxConnections(maxConnections)}}{
     Set the maximum number of connections. Default is set to 10.
   }
   \item{\code{setMinConnections(minConnections)}}{
     Set the minimum number of connections. Default is set to 1.
   }
   \item{\code{setFetchSize(fetchSize)}}{
     Set the fetch size. Default is set to 10.
   }
   \item{\code{setConnectionTimeout(seconds)}}{
     Set the connection timeout. Default is set to 20s.
   }
   \item{\code{setValidateConnections(validateConnections)}}{
     Set TRUE if connections have to be validated, FALSE otherwise.
   }
   \item{\code{setPrimaryKeyMetadataTable(primaryKeyMetadataTable)}}{
     Set the name of the primaryKey metadata table
   }
   \item{\code{setLooseBBox(looseBBox)}}{
     Set losse bbox parameter.
   }
   \item{\code{setPreparedStatements(preparedStatements)}}{
     Set prepared statements
   }
   \item{\code{setMaxOpenPreparedStatements(maxOpenPreparedStatements)}}{
     Set maximum open prepared statements
   }
   \item{\code{setEstimatedExtends(estimatedExtends)}}{
     Set estimatedExtend parameter
   }
   \item{\code{setDefautConnectionParameters()}}{
     Set default connection parameters
   }
}
}

\section{Methods}{

\describe{
   \item{\code{new(xml, name, description, enabled, database)}}{
     Instantiates a GSGeoPackageDataStore object
   }
}
}

\examples{
ds <- GSGeoPackageDataStore$new(
 name = "ds", description = "des", 
 enabled = TRUE, database = NULL
)


}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{GeoPackage}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSAbstractStore]{geosapi::GSAbstractStore}} -> \code{\link[geosapi:GSAbstractDataStore]{geosapi::GSAbstractDataStore}} -> \code{\link[geosapi:GSAbstractDBDataStore]{geosapi::GSAbstractDBDataStore}} -> \code{GSGeoPackageDataStore}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSGeoPackageDataStore-new}{\code{GSGeoPackageDataStore$new()}}
\item \href{#method-GSGeoPackageDataStore-clone}{\code{GSGeoPackageDataStore$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setDescription"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setDescription'><code>geosapi::GSAbstractStore$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setEnabled"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setEnabled'><code>geosapi::GSAbstractStore$setEnabled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setType"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setType'><code>geosapi::GSAbstractStore$setType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="addConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-addConnectionParameter'><code>geosapi::GSAbstractDataStore$addConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="decode"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-decode'><code>geosapi::GSAbstractDataStore$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="delConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-delConnectionParameter'><code>geosapi::GSAbstractDataStore$delConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameter'><code>geosapi::GSAbstractDataStore$setConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameters"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameters'><code>geosapi::GSAbstractDataStore$setConnectionParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setConnectionTimeout"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setConnectionTimeout'><code>geosapi::GSAbstractDBDataStore$setConnectionTimeout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setDatabase"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setDatabase'><code>geosapi::GSAbstractDBDataStore$setDatabase()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setDatabaseType"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setDatabaseType'><code>geosapi::GSAbstractDBDataStore$setDatabaseType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setDefautConnectionParameters"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setDefautConnectionParameters'><code>geosapi::GSAbstractDBDataStore$setDefautConnectionParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setEstimatedExtends"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setEstimatedExtends'><code>geosapi::GSAbstractDBDataStore$setEstimatedExtends()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setExposePrimaryKeys"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setExposePrimaryKeys'><code>geosapi::GSAbstractDBDataStore$setExposePrimaryKeys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setFetchSize"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setFetchSize'><code>geosapi::GSAbstractDBDataStore$setFetchSize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setHost"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setHost'><code>geosapi::GSAbstractDBDataStore$setHost()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setJndiReferenceName"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setJndiReferenceName'><code>geosapi::GSAbstractDBDataStore$setJndiReferenceName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setLooseBBox"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setLooseBBox'><code>geosapi::GSAbstractDBDataStore$setLooseBBox()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setMaxConnections"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setMaxConnections'><code>geosapi::GSAbstractDBDataStore$setMaxConnections()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setMaxOpenPreparedStatements"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setMaxOpenPreparedStatements'><code>geosapi::GSAbstractDBDataStore$setMaxOpenPreparedStatements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setMinConnections"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setMinConnections'><code>geosapi::GSAbstractDBDataStore$setMinConnections()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setNamespace"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setNamespace'><code>geosapi::GSAbstractDBDataStore$setNamespace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setPassword"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setPassword'><code>geosapi::GSAbstractDBDataStore$setPassword()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setPort"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setPort'><code>geosapi::GSAbstractDBDataStore$setPort()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setPreparedStatements"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setPreparedStatements'><code>geosapi::GSAbstractDBDataStore$setPreparedStatements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setPrimaryKeyMetadataTable"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setPrimaryKeyMetadataTable'><code>geosapi::GSAbstractDBDataStore$setPrimaryKeyMetadataTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setSchema"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setSchema'><code>geosapi::GSAbstractDBDataStore$setSchema()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setUser"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setUser'><code>geosapi::GSAbstractDBDataStore$setUser()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDBDataStore" data-id="setValidateConnections"><a href='../../geosapi/html/GSAbstractDBDataStore.html#method-GSAbstractDBDataStore-setValidateConnections'><code>geosapi::GSAbstractDBDataStore$setValidateConnections()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSGeoPackageDataStore-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSGeoPackageDataStore-new}{}}}
\subsection{Method \code{new()}}{
initializes an GeoPackage data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSGeoPackageDataStore$new(
  xml = NULL,
  name = NULL,
  description = "",
  enabled = TRUE,
  database = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link{XMLInternalNode-class} to create object from XML}

\item{\code{name}}{coverage store name}

\item{\code{description}}{coverage store description}

\item{\code{enabled}}{whether the store should be enabled or not. Default is \code{TRUE}}

\item{\code{database}}{database}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSGeoPackageDataStore-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSGeoPackageDataStore-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSGeoPackageDataStore$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
