% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-segment.R
\name{geos_segment_intersection}
\alias{geos_segment_intersection}
\alias{geos_orientation_index}
\title{Segment operations}
\usage{
geos_segment_intersection(a, b)

geos_orientation_index(a, point)
}
\arguments{
\item{a, b}{A \code{list()} representing segments in the form
\code{list(x0, y0, x1, y1)}. List items with length 1 will be
recycled to the length of the longest item.}

\item{point}{A \code{list()} representing points in the form \code{list(x, y)}.}
}
\value{
\code{\link[=geos_segment_intersection]{geos_segment_intersection()}} returns a \code{list(x, y)};
\code{\link[=geos_orientation_index]{geos_orientation_index()}} returns -1, 0 or 1, depending if
the \code{point} lies to the right of (-1), is colinear with (0) or
lies to the left of (1) the segment (as judged from the start
of the segment looking towards the end).
}
\description{
Segment operations
}
\examples{
geos_segment_intersection(
  list(0, 0, 10, 10),
  list(10, 0, 0, 10)
)

geos_orientation_index(
  list(0, 0, 10, 10),
  list(15, c(12, 15, 17))
)

}
