% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNAbstractManager.R
\docType{class}
\name{GNAbstractManager}
\alias{GNAbstractManager}
\title{GNAbstractManager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for communication with
the REST API of a GeoNetwork instance.
}
\description{
GNAbstractManager
}
\section{Fields}{

\describe{
\item{\code{loggerType}}{the type of logger}

\item{\code{verbose.info}}{if geosapi logs have to be printed}

\item{\code{verbose.debug}}{if curl logs have to be printed}

\item{\code{url}}{the Base url of GeoNetwork}

\item{\code{version}}{the version of GeoNetwork. Handled as \code{GNVersion} object}

\item{\code{lang}}{the language for Geonetwork service. Default is \code{eng}}

\item{\code{user}}{the user name}
}}

\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, version, logger, keyring_backend)}}{
   This method is used to instantiate a GNManager with the \code{url} of the
   GeoNetwork and credentials to authenticate (\code{user}/\code{pwd}). By default,
   the \code{logger} argument will be set to \code{NULL} (no logger).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the Geonetwork password/token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
 }
 \item{\code{logger(type, text)}}{
   Basic logger to report geonapi logs. Used internally
 }
 \item{\code{INFO(text)}}{
   Logger to report information. Used internally
 }
 \item{\code{WARN(text)}}{
   Logger to report warnings. Used internally
 }
 \item{\code{ERROR(text)}}{
   Logger to report errors. Used internally
 }
 \item{\code{getUrl()}}{
   Get the authentication URL
 }
 \item{\code{getLang()}}{
   Get the service lang
 }
 \item{\code{login(user, pwd)}}{
   This methods (here abstract) attempts a connection to GeoNetwork API. Used internally
   by subclass of \code{GNAbstractManager} to login Geonetwork.
 }
 \item{\code{getClassName()}}{
   Retrieves the name of the class instance
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
