% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNames.R
\name{getNames}
\alias{getNames}
\alias{getNames,ANY-method}
\alias{getNames,geom-method}
\alias{getNames,sf-method}
\alias{getNames,Raster-method}
\title{Get the name(s) of a spatial object.}
\usage{
\S4method{getNames}{ANY}(x)

\S4method{getNames}{geom}(x)

\S4method{getNames}{sf}(x)

\S4method{getNames}{Raster}(x)
}
\arguments{
\item{x}{the object from which to get the name.}
}
\value{
A vector of the names of \code{x}.
}
\description{
Get the name(s) of a spatial object.
}
\examples{
getNames(x = gtGeoms$grid$continuous)

getNames(x = gtSF$polygon)

getNames(x = gtRasters)
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getCols}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayers}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getRows}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
