% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_random.R
\name{gs_random}
\alias{gs_random}
\title{Create a \code{geom} randomly}
\usage{
gs_random(type = "point", window = NULL, vertices = NULL)
}
\arguments{
\item{type}{[\code{character(1)}]\cr Either one of the three main feature
types \code{"point"}, \code{"line"} or \code{"polygon"}, \code{"random"},
or more specifically one of their subtypes, e.g. \code{"hexagon"} (subtypes
currently not yet supported).}

\item{window}{[\code{data.frame(1)}]\cr in case the reference window deviates
from the bounding box [0, 1] (minimum and maximum values), specify this
here.}

\item{vertices}{[\code{integerish(1)}]\cr the number of vertices the geometry
should have; only meaningful if \code{type} does not indicate the number of
vertices already. If left at \code{NULL} the minimum number of vertices for
the \code{geom} type, i.e. 1 for \code{point}, 2 for \code{line} and 3 for
\code{polygon}.}
}
\value{
A \code{geom}.
}
\description{
This function creates a random geometry
}
\examples{
# create a random polygon with five vertices
set.seed(1)
someGeom <- gs_random(type = "polygon", vertices = 5)
visualise(geom = someGeom)

# in case template is given, this serves as source for the window extent
visualise(geom = gs_random(), new = FALSE, linecol = "red")
}
\seealso{
Other geometry shapes: 
\code{\link{gs_line}()},
\code{\link{gs_point}()},
\code{\link{gs_polygon}()}
}
\concept{geometry shapes}
