% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODistribution.R
\docType{class}
\name{ISODistribution}
\alias{ISODistribution}
\title{ISODistribution}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Distribution
}
\description{
ISODistribution
}
\section{Fields}{

\describe{
\item{\code{distributionFormat}}{[\code{\link{ISOFormat}}]}

\item{\code{distributor}}{[\code{\link{ISODistributor}}]}

\item{\code{transferOptions}}{[\code{\link{ISODigitalTransferOptions}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISODistribution}}
 }
 \item{\code{addFormat(format)}}{
   Adds a distribution format, object of class \code{\link{ISOFormat}}
 }
 \item{\code{delFormat(format)}}{
   Deletes a distribution format, object of class \code{\link{ISOFormat}}
 }
 \item{\code{addDistributor(distributor)}}{
   Adds a distributor, object of class \code{\link{ISODistributor}}
 }
 \item{\code{delDistributor(distributor)}}{
   Deletes a distributor, object of class \code{\link{ISODistributor}}
 }
 \item{\code{setDigitalTransferOptions(options)}}{
   Sets the digital transfer options, object of class \code{\link{ISODigitalTransferOptions}}
 }
}
}

\examples{
  md <- ISODistribution$new()
  
  dto <- ISODigitalTransferOptions$new()  
  for(i in 1:3){
   or <- ISOOnlineResource$new()
   or$setLinkage(paste0("http://somelink",i))
   or$setName(paste0("name",i))
   or$setDescription(paste0("description",i))
   or$setProtocol("WWW:LINK-1.0-http--link")
   dto$addOnlineResource(or)
  }
  md$setDigitalTransferOptions(dto)
  
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{distribution}
