% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryAcquisitionInformation.R
\docType{class}
\name{ISOImageryAcquisitionInformation}
\alias{ISOImageryAcquisitionInformation}
\title{ISOImageryAcquisitionInformation}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Imagery AcquisitionInformation
}
\description{
ISOImageryAcquisitionInformation
}
\section{Fields}{

\describe{
\item{\code{instrument}}{[\code{list} of \code{\link{ISOImageryInstrument}}]}

\item{\code{operation}}{[\code{list} of \code{\link{ISOImageryOperation}}]}

\item{\code{platform}}{[\code{list} of \code{\link{ISOImageryPlatform}}]}

\item{\code{acquisitionPlan}}{[\code{list} of \code{\link{ISOImageryPlan}}]}

\item{\code{objective}}{[\code{list} of \code{\link{ISOImageryObjective}}]}

\item{\code{acquisitionRequirement}}{[\code{list} of \code{\link{ISOImageryRequirement}}]}

\item{\code{environmentConditions}}{[\code{\link{ISOImageryEnvironmentalRecord}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryAcquisitionInformation}}
 }
 \item{\code{addInstrument(instrument)}}{
   Adds instrument, object of class \code{\link{ISOImageryInstrument}}
 }
 \item{\code{delInstrument(instrument)}}{
   Deletes instrument, object of class \code{\link{ISOImageryInstrument}}
 }
 \item{\code{addOperation(operation)}}{
   Adds instrument, object of class \code{\link{ISOImageryOperation}}
 }
 \item{\code{delOperation(operation)}}{
   Deletes operation, object of class \code{\link{ISOImageryOperation}}
 }
 \item{\code{addPlatform(platform)}}{
   Adds platform, object of class \code{\link{ISOImageryPlatform}}
 }
 \item{\code{delPlatform(platform)}}{
   Deletes platform, object of class \code{\link{ISOImageryPlatform}}
 }
 \item{\code{addPlan(plan)}}{
   Adds plan, object of class \code{\link{ISOImageryPlan}}
 }
 \item{\code{delPlan(plan)}}{
   Deletes plan, object of class \code{\link{ISOImageryPlan}}
 }
 \item{\code{addObjective(objective)}}{
   Adds objective, object of class \code{\link{ISOImageryObjective}}
 }
 \item{\code{delObjective(objective)}}{
   Deletes objective, object of class \code{\link{ISOImageryObjective}}
 }
 \item{\code{addRequirement(requirement)}}{
   Adds requirement, object of class \code{\link{ISOImageryRequirement}}
 }
 \item{\code{delRequirement(requirement)}}{
   Deletes requirement, object of class \code{\link{ISOImageryRequirement}}
 }
 \item{\code{setEnvironmentConditions(conditions)}}{
   Set environment conditions, object of class \code{\link{ISOImageryEnvironmentalRecord}}
 }
}
}

\examples{
    md = ISOImageryAcquisitionInformation$new()
    
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- AcquisitionInformation -- Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{AcquisitionInformation}
\keyword{ISO}
\keyword{element}
\keyword{imagery}
