% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODimension.R
\docType{class}
\name{ISODimension}
\alias{ISODimension}
\title{ISODimension}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Dimension
}
\description{
ISODimension
}
\section{Fields}{

\describe{
\item{\code{dimensionName}}{[\code{\link{ISODimensionNameType}}] dimension name}

\item{\code{dimensionSize}}{[\code{\link{integer}}] dimension size}

\item{\code{resolution}}{[\code{\link{ISOMeasure}}] resolution}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml,value)}}{
   This method is used to instantiate an \code{\link{ISODimension}}
 }
 \item{\code{setName(name)}}{
   Sets the dimension name. Object of class \code{ISODimensionNameType} or
   any value from \code{ISODimensionNameType$values()}
 }
 \item{\code{setSize(size)}}{
   Sets the dimension size, object of class \code{integer}
 }
 \item{\code{setResolution(resolution)}}{
  Sets the resolution ie. object of class \code{\link{ISOMeasure}} or any subclass
  \code{\link{ISOLength}}, \code{\link{ISODistance}}, \code{\link{ISOAngle}}, \code{\link{ISOScale}}
 }
}
}

\examples{
   #create dimension
   md <- ISODimension$new()
   md$setName("row")
   md$setSize(1)
   md$setResolution(ISOLength$new(value=1,uom="m"))
   xml <- md$encode()
   
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{dimension}
