% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOQuantitativeResult.R
\docType{class}
\name{ISOQuantitativeResult}
\alias{ISOQuantitativeResult}
\title{ISOQuantitativeResult}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO QuantitativeResult
}
\description{
ISOQuantitativeResult
}
\section{Fields}{

\describe{
\item{\code{valueType}}{[\code{\link{ISORecordType}}] record type}

\item{\code{valueUnit}}{[\code{\link{GMLUnitDefinition}}] unit}

\item{\code{errorStatistic}}{[\code{\link{character}}] error statistic}

\item{\code{value}}{[\code{\link{ISORecord}}] record(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOQuantitativeResult}}
 }
 \item{\code{setValueType(valueType)}}{
   Sets value type
 }
 \item{\code{setValueUnit(valueUnit)}}{
   Sets value unit
 }
 \item{\code{setErrorStatistic(errorStatistic)}}{
   Sets error statistic
 }
 \item{\code{addValue(value)}}{
   Add value
 }
 \item{\code{delValue(value)}}{
   Deletes value
 }
}
}

\examples{
 md <- ISOQuantitativeResult$new()
 xml <- md$encode()
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{Quantitative}
\keyword{result}
