% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INSPIREMetadataValidator.R
\docType{class}
\name{INSPIREMetadataValidator}
\alias{INSPIREMetadataValidator}
\title{INSPIREMetadataValidator}
\format{\code{\link{R6Class}} object.}
\usage{
INSPIREMetadataValidator
}
\value{
Object of \code{\link{R6Class}} for setting an INSPIREMetadataValidator
}
\description{
INSPIREMetadataValidator
}
\section{Methods}{

\describe{
 \item{\code{new()}}{
   This method is used to instantiate an INSPIRE Metadata validator
 }
 \item{\code{uploadFile(path)}}{
   Upload a XML metadata file to INSPIRE web-service. Method called internally through
   \code{getValidationReport}.
 }
 \item{\code{getValidationReport(obj, file, raw)}}{
   Get validation report for a metadata specified either as R object of class
   \code{ISOMetadata} (from \pkg{geometa} package) or \code{XMLInternalNode} 
   (from \pkg{XML} package), or as XML file, providing the path of the XML file
   to be sent to the INSPIRE metadata validator web-service. By default, a summary
   report is returned. To append the raw response of INSPIRE validation web-service
   to the summary report, set \code{raw = TRUE}.
 }
}
}

\examples{
 \donttest{
  inspireValidator <- INSPIREMetadataValidator$new()
  inspireReport <- inspireValidator$getValidationReport(obj = ISOMetadata$new())
 }

}
\references{
INSPIRE Reference Validator Web Service (http://inspire.ec.europa.eu/validator/swagger-ui.html)
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{INSPIRE}
\keyword{metadata}
\keyword{validation}
\keyword{validator}
