% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageDescription.R
\docType{class}
\name{ISOImageDescription}
\alias{ISOImageDescription}
\title{ISOImageDescription}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageDescription
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOImageDescription
}
\description{
ISOImageDescription
}
\section{Fields}{

\describe{
\item{\code{illuminationElevationAngle}}{[\code{\link{numeric}}]}

\item{\code{illuminationAzimuthAngle}}{[\code{\link{numeric}}]}

\item{\code{imagingCondition}}{[\code{\link{ISOImagingCondition}}]}

\item{\code{imageQualityCode}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{cloudCoverPercentage}}{[\code{\link{numeric}}]}

\item{\code{processingLevelCode}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{compressionGenerationQuantity}}{[\code{\link{integer}}]}

\item{\code{triangulationIndicator}}{[\code{\link{logical}}]}

\item{\code{radiometricCalibrationDataAvailability}}{[\code{\link{logical}}]}

\item{\code{cameraCalibrationInformationAvailability}}{[\code{\link{logical}}]}

\item{\code{filmDistortionInformationAvailability}}{[\code{\link{logical}}]}

\item{\code{lensDistortionInformationAvailability}}{[\code{\link{logical}}]}
}}

\section{Inherited methods from \code{\link{ISOCoverageDescription}}}{

\describe{
 \item{\code{setAttributeDescription}}{
   Sets the attribute description, as object of class \code{\link{ISORecordType}} or
   \code{character}
 }
 \item{\code{setContentType(contentType)}}{
   Sets the content Type, as object of class \code{\link{ISOCoverageContentType}} or
   any \code{character} value listed in \code{ISOCoverageContentType$values()}
 }
 \item{\code{addDimension(dimension)}}{
   Adds a dimension, object of class (or subclass of) \code{\link{ISORangeDimension}}
 }
 \item{\code{delDimension(dimension)}}{
   Deletes a dimension, object of class (or subclass of) \code{\link{ISORangeDimension}}
 }
}
}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageDescription}}
 }
 \item{\code{setIlluminationElevationAngle(illuminationElevationAngle)}}{
   Sets the illumination elevation angle
 }
 \item{\code{setIlluminationAzimuthAngle(illuminationAzimuthAngle)}}{
   Sets the illumination azimuth angle
 }
 \item{\code{setImagingCondition(imagingCondition)}}{
   Sets the imaging condition, object of class 'character' or \code{\link{ISOImagingCondition}}
 }
 \item{\code{setImageQualityCode(code)}}{
   Sets an image quality code
 }
 \item{\code{setCloudCoverPercentage(cloudCoverPercentage)}}{
   Sets the cloud cover percentage
 }
 \item{\code{setProcessingLevelCode(code)}}{
   Sets the processing level code
 }
 \item{\code{setCompressionGenerationQuantity(quantity)}}{
   Sets compression generation quantity
 }
 \item{\code{setTriangulationIndicator(triangulationIndicator)}}{
   Sets the triangulation indicator
 }
 \item{\code{setRadiometricCalibrationDataAvailability(radiometricCalibrationDataAvailability)}}{
   Sets \code{TRUE} if radiometric calibration data is available, \code{FALSE} otherwise
 }
 \item{\code{setCameraCalibrationInformationAvailability(cameraCalibrationInformationAvailability)}}{
   Sets \code{TRUE} if camera calibration information is available, \code{FALSE} otherwise
 }
 \item{\code{setFilmDistortionInformationAvailability(filmDistortionInformationAvailability)}}{
   Sets \code{TRUE} if film distortion information is available, \code{FALSE} otherwise
 }
 \item{\code{setLensDistortionInformationAvailability(lensDistortionInformationAvailability)}}{
   Sets \code{TRUE} if lens distortion information is available, \code{FALSE} otherwise
 }
}
}

\examples{
   #create image description
   md <- ISOImageDescription$new()
   md$setAttributeDescription("test")
   md$setContentType("modelResult")
   
   #adding 3 arbitrary dimensions
   for(i in 1:3){
      band <- ISOBand$new()
      mn <- ISOMemberName$new(aName = sprintf("name \%s",i), attributeType = sprintf("type \%s",i))
      band$setSequenceIdentifier(mn)
      band$setDescriptor("descriptor")
      band$setMaxValue(10)
      band$setMinValue(1)
      gml <- GMLBaseUnit$new(id = sprintf("ID\%s",i))
      gml$setDescriptionReference("someref")
      gml$setIdentifier("identifier", "codespace")
      gml$addName("name1", "codespace")
      gml$addName("name2", "codespace")
      gml$setQuantityTypeReference("someref")
      gml$setCatalogSymbol("symbol")
      gml$setUnitsSystem("somelink")
      band$setUnits(gml)
      band$setPeakResponse(9)
      band$setBitsPerValue(5)
      band$setToneGradation(100)
      band$setScaleFactor(1)
      band$setOffset(4)
      md$addDimension(band)
   }
   
   md$setIlluminationElevationAngle(15)
   md$setIlluminationAzimuthAngle(10)
   md$setImagingCondition("rain")
   md$setImageQualityCode("bad")
   md$setCloudCoverPercentage(90)
   md$setProcessingLevelCode("high")
   md$setCompressionGenerationQuantity(1L)
   md$setTriangulationIndicator(FALSE)
   md$setRadiometricCalibrationDataAvailability(FALSE)
   md$setCameraCalibrationInformationAvailability(FALSE)
   md$setFilmDistortionInformationAvailability(FALSE)
   md$setLensDistortionInformationAvailability(FALSE)
   
   xml <- md$encode()
   
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{coverage}
\keyword{description}
