% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODate.R
\docType{class}
\name{ISODate}
\alias{ISODate}
\title{ISODate}
\format{\code{\link{R6Class}} object.}
\usage{
ISODate
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Date
}
\description{
ISODate
}
\section{Fields}{

\describe{
\item{\code{date}}{[\code{\link{ISOBaseDate}}] the date}

\item{\code{dateType}}{[\code{\link{ISODateType}}] the date type}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISODate}}
 }
 \item{\code{setDate(date)}}{
   Sets the date
 }
 \item{\code{setDateType(dateType)}}{
   Sets the date type
 }
}
}

\examples{
  md <- ISODate$new()
  md$setDate(ISOdate(2015, 1, 1, 1))
  md$setDateType("publication")
  xml <- md$encode()

}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{date}
