% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOGridSpatialRepresentation.R
\docType{class}
\name{ISOGridSpatialRepresentation}
\alias{ISOGridSpatialRepresentation}
\title{ISOGridSpatialRepresentation}
\format{\code{\link{R6Class}} object.}
\usage{
ISOGridSpatialRepresentation
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO GridSpatialRepresentation
}
\description{
ISOGridSpatialRepresentation
}
\section{Fields}{

\describe{
\item{\code{transformationParameterAvailability}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOGridSpatialRepresentation
 }
 \item{\code{setNumberOfDimensions}}{
   Sets the number of dimensions (value of class \code{integer})
 }
 \item{\code{addDimension(dimension)}}{
   Adds a dimension. Object of class \code{ISODimension}
 }
 \item{\code{delDimension(dimension)}}{
   Deletes a dimension;
 }
 \item{\code{setCellGeometry(cellGeometry)}}{
   Sets the cell geometry. Object of class \code{ISOCellGeometry} or any value
   from \code{ISOCellGeometry$values()}
 }
 \item{\code{setTransformationParameterAvailability(availability)}}{
   Sets the transformation parameter availability
 }
}
}

\examples{
  md <- ISOGridSpatialRepresentation$new()
  md$setNumberOfDimensions(1)
  dim1 <- ISODimension$new()
  dim1$setName("row")
  dim1$setSize(100)
  dim1$setResolution(ISOMeasure$new(value=1,uom="m"))
  md$addDimension(dim1)
  md$setCellGeometry("area")
  xml <- md$encode()

}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{grid}
\keyword{representation}
\keyword{spatial}
