% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate_down}
\alias{estimate_down}
\title{Estimate Down Levels}
\usage{
estimate_down(wts, value, group)
}
\arguments{
\item{wts}{numeric vector. Defaults to 1. Typically population or VAP, as a weight to give each precinct.}

\item{value}{numeric vector. Defaults to 1. Typically electoral outcomes, as a value to estimate down into blocks.}

\item{group}{matches of length(wts) that correspond to row indices of value. Often, this input is the output of geo_match.}
}
\value{
numeric vector with each value split by weight
}
\description{
Non-geographic partner function to geo_estimate_down. Allows users to estimate 
down without the costly matching operation if they've already matched.
}
\examples{
library(dplyr)
set.seed(1)
data(checkerboard)
counties <- checkerboard \%>\% group_by(id <= 32) \%>\% 
summarize(geometry = sf::st_union(geometry)) \%>\% mutate(pop = c(100,200))
matches <- geo_match(checkerboard, counties)
estimate_down(wts = rep(1, nrow(checkerboard)), value = counties$pop, group = matches)

}
\concept{estimate}
