% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson_validate.R
\name{geojson_validate}
\alias{geojson_validate}
\title{Validate GeoJSON using is-my-json-valid Javascript library}
\usage{
geojson_validate(x, inform = FALSE, error = FALSE, greedy = FALSE)
}
\arguments{
\item{x}{Input, a geojson character string, json object, or file or
url pointing to one of the former}

\item{inform}{(logical) When geojson is invalid, return reason why (\code{TRUE})
or don't return reason  \code{FALSE}). Default: \code{FALSE}}

\item{error}{(logical) Throw an error on parse failure? If \code{TRUE}, then
function returns \code{NULL} on success, and \code{stop} with the
error message on error. Default: \code{FALSE}}

\item{greedy}{(logical) Continue after the first error? \code{TRUE} or \code{FALSE}.
Default: \code{FALSE}}
}
\value{
\code{TRUE} or \code{FALSE}. If \code{inform=TRUE} an attribute
of name \code{errors} is added with error information
}
\description{
Validate GeoJSON using is-my-json-valid Javascript library
}
\details{
Sometimes you may get a response that your input GeoJSON is
invalid, but get a somewhat unhelpful error message, e.g.,
\verb{no (or more than one) schemas match}. See
\url{https://github.com/ropensci/geojsonlint/issues/7#issuecomment-219881961}.
We'll hopefully soon get this sorted out so you'll get a meaningful error
message. However, this method is faster than the other two methods in
this package, so there is that.
}
\examples{
# From a json character string
## good
geojson_validate('{"type": "Point", "coordinates": [-100, 80]}')
## bad
geojson_validate(
 '{"type": "Rhombus", "coordinates": [[1, 2], [3, 4], [5, 6]]}')

# A file
file <- system.file("examples", "zillow_or.geojson",
  package = "geojsonlint")
geojson_validate(x = as.location(file))

# A URL
if (interactive()) {
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_validate(as.location(url))
}

# toggle whether reason for validation failure is given back
geojson_validate('{ "type": "FeatureCollection" }')
geojson_validate('{ "type": "FeatureCollection" }', inform = TRUE)

# toggle whether to stop with error message
geojson_validate('{ "type": "FeatureCollection" }')
geojson_validate('{ "type": "FeatureCollection" }', inform = TRUE)
if (interactive()) {
geojson_validate('{ "type": "FeatureCollection" }', error = TRUE)
}
}
\references{
\url{https://www.npmjs.com/package/is-my-json-valid}
}
