% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_early_warning.R
\name{get_early_warning}
\alias{get_early_warning}
\title{Download information on the latest deforestation alerts detected by Geobosque}
\usage{
get_early_warning(region, sf = TRUE, show_progress = TRUE)
}
\arguments{
\item{region}{A string Specifies the unique geographical code of interest.}

\item{sf}{Logical. Indicates whether to return the data as an `sf` object.}

\item{show_progress}{Logical. If TRUE, shows a progress bar during download.}
}
\value{
A tibble or sf object, depending on the value of `sf`.
}
\description{
This function allows you to download deforestation alert information detected by Geobosque
for any polygon located in Peru.
For more details, please visit the following website: \url{https://geobosques.minam.gob.pe}
}
\examples{
\donttest{
library(geoidep)
amazonas <- get_departaments(show_progress = FALSE) |> subset(NOMBDEP == "AMAZONAS")
warning_point <- get_early_warning(region = amazonas, sf = TRUE, show_progress = FALSE)
head(warning_point)
}
}
