% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_folder.R
\name{uscb_folder}
\alias{uscb_folder}
\title{\code{uscb_folder} S3 class}
\usage{
uscb_folder(ul, year = NULL)
}
\arguments{
\item{ul}{A \code{uscb_folder} object.}

\item{year}{A vector of years.}
}
\value{
A \code{uscb_folder} object.
}
\description{
A \code{uscb_folder} object is created from a \code{uscb_layer} object and the
geodatabases of the same layer group corresponding to other years located in
the same folder
}
\details{
If the vector of years is not indicated, the geodatabases of all the years
located in the same folder are considered.
}
\examples{
library(tidyr)

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua \%>\% get_statistical_areas()
# sa[6]
# [1] "New England City and Town Area Division"
ul <- uscb_layer(uscb_acs_metadata, ua = ua, geodatabase = sa[6], year = 2015)
layers <- ul \%>\% get_layer_names()
# layers[3]
# [1] "X02_RACE"
ul <- ul \%>\% get_layer(layers[3])
lg <- ul \%>\% get_layer_group_names()
# lg[2]
# [1] "003 - DETAILED RACE"
ul <- ul \%>\% get_layer_group(lg[2])

uf <- uscb_folder(ul)

}
\seealso{


Other data selection functions: 
\code{\link{get_layer_group_names}()},
\code{\link{get_layer_group}()},
\code{\link{get_layer_names}()},
\code{\link{get_layer}()},
\code{\link{uscb_layer}()}
}
\concept{data selection functions}
