% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelplotRaw.r
\name{levelplotRaw}
\alias{levelplotRaw}
\title{Levelplot of Raw Data}
\usage{
levelplotRaw(Profile, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(Profile@title, "without topography (raw data)"),
  col = colors, trafo = log, ...)
}
\arguments{
\item{Profile}{profile.}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.}

\item{col}{vector of colors.}

\item{trafo}{function to transform raw data values (default: log).}

\item{...}{lattice levelplot arguments.}
}
\description{
Plots raw data values without topography (height adjustment).
The raw data values have not been inverted yet.
}
\examples{
data(sinkhole)

levelplotRaw(sinkhole@profiles[[1]])
levelplotLegendLabel()

levelplotRaw(sinkhole@profiles[[2]])
levelplotLegendLabel()

levelplotRaw(sinkhole@profiles[[3]])
levelplotLegendLabel()
}

