% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surfacearea.R
\name{flatsa}
\alias{flatsa}
\title{Flattened Surface Area}
\usage{
flatsa(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A numeric value representing the scaled surface
  area of a flattened surface with the same x, y bounds.
}
\description{
Calculates the surface area of a flat raster or matrix with the
same x, y bounds as the study surface.
}
\details{
This function scales both x and y to between 0 and 1. This
is done because most satellite data have units where the x,
y units do not equal the z units and because the flat
surface area is usually compared to the actual surface area.
Surface area is calculated over the sample area (N-1, M-1).
}
\examples{
# import raster image
data(normforest)

# calculate flattened surface area
flatsa(normforest)
}
