% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearingarea.R
\name{bearing_area}
\alias{bearing_area}
\title{Calculates the Rotated Bearing Area Curve}
\usage{
bearing_area(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A function describing the rotated Bearing Area curve.
}
\description{
Finds a rotated version of the Bearing Area (Abbott-Firestone)
curve from a raster or matrix. The resulting function should be
rotated 90 degrees clockwise to get the actual Bearing
Area curve.
}
\examples{
# import raster image
data(normforest)

# find the rotated Bearing Area curve.
ba_func <- bearing_area(normforest)

# rotate the values and re-plot
xval <- environment(ba_func)$y
yval <- (1 - environment(ba_func)$x)
plot(yval ~ xval)
}
