% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolevel_complete_point_geometry.R
\name{complete_point_geometry}
\alias{complete_point_geometry}
\alias{complete_point_geometry.geolevel}
\title{Complete point geometry}
\usage{
complete_point_geometry(gl, use_intermediate_projected_crs = FALSE)

\method{complete_point_geometry}{geolevel}(gl, use_intermediate_projected_crs = FALSE)
}
\arguments{
\item{gl}{A \code{geolevel} object.}

\item{use_intermediate_projected_crs}{A boolean.}
}
\value{
A \code{geolevel} object.
}
\description{
In case of having the polygon geometry defined, it obtains the point geometry
from it.
}
\details{
If the point geometry was already defined, if there are instances with this
geometry empty, it completes them.

If the geometry of the CRS is not projected, it warns that the calculations
may not be correct. A projected intermediate geometry can be used to perform
the operation, indicating it by the boolean parameter.
}
\examples{
state <-
  geolevel(name = "state",
           layer = layer_us_state,
           key = c("geoid")) |>
  complete_point_geometry()

}
\seealso{
Other level definition functions: 
\code{\link{check_key}()},
\code{\link{coordinates_to_geometry}()},
\code{\link{get_empty_geometry_instances}()},
\code{\link{get_geometry}()}
}
\concept{level definition functions}
