% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_evaluation.R
\name{calcqualityIndexes}
\alias{calcqualityIndexes}
\title{Quality indexes}
\usage{
calcqualityIndexes(
  data,
  belongmatrix,
  m,
  indices = c("Silhouette.index", "Partition.entropy", "Partition.coeff",
    "XieBeni.index", "FukuyamaSugeno.index", "Explained.inertia")
)
}
\arguments{
\item{data}{The original dataframe used for the classification (n*p)}

\item{belongmatrix}{A membership matrix (n*k)}

\item{m}{The fuzziness parameter used for the classification}

\item{indices}{A character vector with the names of the indices to calculate, default is :
c("Silhouette.index", "Partition.entropy", "Partition.coeff", "XieBeni.index", "FukuyamaSugeno.index",
"Explained.inertia"). Other available indices are : "DaviesBoulin.index", "CalinskiHarabasz.index",
"GD43.index", "GD53.index" and "Negentropy.index"}
}
\value{
A named list with with the values of the required indices
}
\description{
calculate several clustering quality indexes (some of them come from fclust
package)
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcqualityIndexes(result$Data,result$Belongings, m=1.5)
}
