% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCM.R
\name{CMeans}
\alias{CMeans}
\title{C-means}
\usage{
CMeans(
  data,
  k,
  m,
  maxiter = 500,
  tol = 0.01,
  standardize = TRUE,
  verbose = TRUE,
  init = "random",
  seed = NULL
)
}
\arguments{
\item{data}{A dataframe with only numerical variables. Can also be a list of
rasters (produced by the package raster). In that case, each raster is
considered as a variable and each pixel is an observation. Pixels with NA
values are not used during the classification.}

\item{k}{An integer describing the number of cluster to find}

\item{m}{A float for the fuzziness degree}

\item{maxiter}{An integer for the maximum number of iterations}

\item{tol}{The tolerance criterion used in the evaluateMatrices function for
convergence assessment}

\item{standardize}{A boolean to specify if the variables must be centred and
reduced (default = True)}

\item{verbose}{A boolean to specify if the progress should be printed}

\item{init}{A string indicating how the initial centres must be selected. "random"
indicates that random observations are used as centres. "kpp" use a distance-based method
resulting in more dispersed centres at the beginning. Both of them are heuristic.}

\item{seed}{An integer used for random number generation. It ensures that the
starting centres will be the same if the same value is selected.}
}
\value{
An S3 object of class FCMres with the following slots
\itemize{
        \item Centers: a dataframe describing the final centers of the groups
        \item Belongings: the final membership matrix
        \item Groups: a vector with the names of the most likely group for each observation
        \item Data: the dataset used to perform the clustering (might be standardized)
        \item isRaster: TRUE if rasters were used as input data, FALSE otherwise
        \item k: the number of groups
        \item m: the fuzyness degree
        \item alpha: the spatial weighting parameter (if SFCM or SGFCM)
        \item beta: beta parameter for generalized version of FCM (GFCM or SGFCM)
        \item algo: the name of the algorithm used
        \item rasters: a list of rasters with membership values and the most likely group (if rasters were used)
        \item missing: a boolean vector indicating raster cell with data (TRUE) and with NA (FALSE) (if rasters were used)
        \item maxiter: the maximum number of iterations used
        \item tol: the convergence criterio
        \item lag_method: the lag function used (if SFCM or SGFCM)
        \item nblistw: the neighbours list used (if vector data were used for SFCM or SGFCM)
        \item window: the window used (if raster data were used for SFCM or SGFCM)
}
}
\description{
The classical c-mean algorithm
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
result <- CMeans(dataset,k = 5, m = 1.5, standardize = TRUE)
}
