% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_base_dens.R
\name{get_base_dens}
\alias{get_base_dens}
\title{Get baseline densities}
\usage{
get_base_dens(
  data,
  coordinates = c("longitude", "latitude"),
  window,
  grayscale = FALSE
)
}
\arguments{
\item{data}{dataframe}

\item{coordinates}{vector of column names of longitudes and latitudes (in this order)}

\item{window}{owin object}

\item{grayscale}{logical. `grayscale` specifies whether to convert plot to grayscale (by default, FALSE).}
}
\value{
list of the following:
    * `density`: im object of baseline density
    * `density_plot`: ggplot object of baseline density
    * `point_plot`: ggplot object of raw data
}
\description{
`get_base_dens()` takes a dataframe and 
returns the baseline densities using Scott's rule of thumb.
}
\examples{
get_base_dens(data = airstrikes_base, 
              coordinates = c("longitude", "latitude"),
              window = iraq_window,
              grayscale = FALSE)
}
