% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpcList-Methods.R
\name{spc.plot.grid}
\alias{spc.plot.grid}
\alias{spc.plot.grid,SpcList-method}
\title{Plotting \code{SpcList} object in a grid}
\usage{
spc.plot.grid(x,FUN, nnrow, nncol, mar,oma, lab_cex, ...)

\S4method{spc.plot.grid}{SpcList}(
  x,
  FUN,
  nnrow,
  nncol,
  mar = c(4, 4.5, 1, 0.5),
  oma = c(0, 0, 0, 0),
  lab_cex,
  ...
)
}
\arguments{
\item{x}{a \code{SpcList} data}

\item{FUN}{a character string giving the name of the ploting function to be used. 
Can be either of "spc.plot"}

\item{nnrow}{number of rows for the grid to be produced}

\item{nncol}{number of columns for the grid to be produced}

\item{mar}{A numeric vector of length 4, which sets the margin sizes in the following order: bottom, left, top, and right. The default is c(4,4.5,1,0.5)}

\item{oma}{oma the "outer margin area" around a figure or figures. The usage of mar and oma is shown when plotting a single figure,}

\item{lab_cex}{vector of character expansion sizes, used cyclically}

\item{...}{any further arguments of plot}
}
\description{
Generating plot of the contents of a \code{SpcList} object in a grid
}
\examples{
sp <- spc.example_spectra()
BL = spc.makeSpcList(sp,"CAST")
spc.plot.grid(BL,"spc.plot",3,2)

}
