% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R, R/SpcList-Methods.R
\docType{methods}
\name{spc.updateheader}
\alias{spc.updateheader}
\alias{spc.updateheader,Spectra-method}
\alias{spc.updateheader,list-method}
\title{Update a field of the @header slot of a \code{Spectra} object}
\usage{
spc.updateheader(object,Name,value,...)

\S4method{spc.updateheader}{Spectra}(object, Name, value, ...)

\S4method{spc.updateheader}{list}(object, Name, value)
}
\arguments{
\item{object}{A \code{Spectra} object}

\item{Name}{of the header field to be updated}

\item{value}{to update header with}

\item{...}{arguments to be passed to or from other methods}
}
\description{
Updates or changes the value of a field in the header slot of \code{Spectra} object
}
\examples{
sp=spc.example_spectra()
sp@header
sp <- spc.updateheader(sp,"Station", 11)
sp@header

#SpcList example
sp=spc.example_spectra()
BL=spc.makeSpcList(sp,"CAST")
BL[[1]]@header
BL[[1]] <- spc.updateheader(BL[[1]],"Station", 11)
BL[[1]]@header

}
