% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/combine.rt.R
\name{combine.rt}
\alias{combine.rt}
\title{Aggregate data on square grid, pad with zeros.  Faster than tapply.}
\usage{
combine.rt(lat, lon, z, grlat, grlon = 0, fun, fill = F, reg = 0,
  minnumber = 2, wsp = 0, wz = 0, wlat = 0, xy = F, rat = 0.2, type)
}
\arguments{
\item{lat}{Latitude of datapoints. ( or x coordinates)}

\item{lon}{Longitude of datapoints. (or y coordinate)}

\item{z}{Values at datapoints.}

\item{grlat}{Latitude of defined grid.}

\item{grlon}{Longitude of defined grid.  If 0 grlat is a list with
components \$lat and \$lon.}

\item{fun}{Function (?).}

\item{fill}{If fill is T the center points of squares where the number of
points does not reach the minimum is set to zero.  Good for data like
trawlers report where it can be assumed that there is little fish where they
do not try.}

\item{reg}{List with two components \$lat and \$lon.  Points outside region
are not returned.  The list is typically output from the program
define.area.}

\item{minnumber}{Minimum number of points needed for the square to be valid.
Default value is 2.}

\item{wsp}{Workspace.  Not of interest.}

\item{wz}{Weighing for the z values.  If one is trying to find the mean
tons/hour in an area is it reasonable to weigh tons/hour by the catch.  If
the weight is zero within a square unweighed mean is used.}

\item{wlat}{Weighing to find the mean latitude and mean longitude.  It is
often reasonable to weigh the latitude and the longitude by the catch.}

\item{xy}{Projected? Default unprojected (lat/lon) values, \code{FALSE}.}

\item{rat}{Ratio for "rm.outliers".  If rat is for example 0.2 20\% of the
points on each side are moved.  i.e. the middle 60\% are kept.  Default
value is 0.6.}

\item{type}{Only value with description \code{rm.outliers}.}
}
\description{
Function that smooths data so data.  In each given square where the number
of points exceeds certain minimum the program gives the mean, sum, variance
or median of the points within the square as well as the number of points
and indication if the minimum number of points was reached.  For each
datapoint latitude, longitude and z has to be given.  The program returns
the mean and mean longitude for points within a square, as well as the
number of points behind that point. The program also has the possibility to
remove outliers within each square. This program can be used to prepare data
for the program pointkriging if the data is so dense in certain places that
it disturbs the neighbourhood search or if there are +10000 datapoints.
}
\details{
It can also be used to find sums or averages of points within squares.

The program works quite fast even for very large datasets.
}
\section{Value}{
 <s-example> List with components \$lat,\$lon,\$z,\$n and
\$fill.  \$lat mean latitude of points within each square.  \$lon mean
longitude of points within each square \$z sum, mean, variance or median of
data \$n Number of points behind point.

If type = "rm.outliers" \$n this component stores the number of the square
corresponding to each point. \$fill If 0 there are datapoints behind the
points else it is an artificial point. (fill = T) </s-example>
}
\seealso{
\code{\link{variogram}}, \code{\link{variofit}},
\code{\link{pointkriging}}, \code{\link{grid}},
\code{\link{geocontour.fill}}.
}
\keyword{<!--Put}
\keyword{here-->}
\keyword{more}
\keyword{one}
\keyword{or}
\keyword{s-keyword}
\keyword{tags}

